/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.annotations.base;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.ImperatConfig;
import dev.velix.imperat.annotations.Default;
import dev.velix.imperat.annotations.DefaultProvider;
import dev.velix.imperat.annotations.Flag;
import dev.velix.imperat.annotations.Named;
import dev.velix.imperat.annotations.Switch;
import dev.velix.imperat.annotations.base.element.MethodElement;
import dev.velix.imperat.annotations.base.element.ParameterElement;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.help.CommandHelp;
import dev.velix.imperat.resolvers.ContextResolver;
import dev.velix.imperat.supplier.OptionalValueSupplier;
import dev.velix.imperat.util.TypeUtility;
import dev.velix.imperat.util.TypeWrap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnnotationHelper {
    public static boolean isMethodHelp(Method method) {
        for (Parameter parameter : method.getParameters()) {
            if (!TypeUtility.areRelatedTypes(parameter.getParameterizedType(), CommandHelp.class)) continue;
            return true;
        }
        return false;
    }

    public static <S extends Source> Object[] loadParameterInstances(Imperat<S> dispatcher, List<CommandParameter<S>> fullParameters, S source, ExecutionContext<S> context, MethodElement method) throws ImperatException {
        Object[] paramsInstances = new Object[method.getParameters().size()];
        ParameterElement firstParam = method.getParameterAt(0);
        assert (firstParam != null);
        paramsInstances[0] = dispatcher.canBeSender(firstParam.getType()) ? (source.getClass().equals(firstParam.getType()) ? source : context.getResolvedSource(firstParam.getType())) : context.getResolvedSource(firstParam.getType());
        int i = 1;
        int p = 0;
        while (i < method.size()) {
            ParameterElement actualParameter = method.getParameterAt(i);
            assert (actualParameter != null);
            ContextResolver contextResolver = dispatcher.config().getMethodParamContextResolver(actualParameter);
            if (contextResolver != null) {
                paramsInstances[i] = contextResolver.resolve(context, actualParameter);
                --p;
            } else {
                CommandParameter<S> parameter = AnnotationHelper.getUsageParam(fullParameters, p);
                if (parameter == null) {
                    if (actualParameter.isAnnotationPresent(Flag.class)) {
                        Flag flag = actualParameter.getAnnotation(Flag.class);
                        assert (flag != null);
                        if (flag.free()) {
                            paramsInstances[i] = context.getFlagValue(flag.value()[0]);
                        } else {
                            throw new IllegalArgumentException();
                        }
                    }
                    --p;
                } else {
                    String name = parameter.name();
                    paramsInstances[i] = parameter.isFlag() ? context.getFlagValue(name) : context.getArgument(name);
                }
            }
            ++i;
            ++p;
        }
        return paramsInstances;
    }

    @Nullable
    private static <S extends Source> CommandParameter<S> getUsageParam(List<? extends CommandParameter<S>> params, int index) {
        if (index < 0 || index >= params.size()) {
            return null;
        }
        return params.get(index);
    }

    @NotNull
    public static <S extends Source> String getParamName(ImperatConfig<S> imperat, Parameter parameter, @Nullable Named named, @Nullable Flag flag, @Nullable Switch switchAnnotation) {
        String name = named != null ? named.value() : (flag != null ? flag.value()[0] : (switchAnnotation != null ? switchAnnotation.value()[0] : parameter.getName()));
        return imperat.replacePlaceholders(name);
    }

    @NotNull
    public static <S extends Source> String getParamName(ImperatConfig<S> imperat, Parameter parameter) {
        return AnnotationHelper.getParamName(imperat, parameter, parameter.getAnnotation(Named.class), parameter.getAnnotation(Flag.class), parameter.getAnnotation(Switch.class));
    }

    @NotNull
    public static <T> OptionalValueSupplier<T> getOptionalValueSupplier(Parameter parameter, Class<? extends OptionalValueSupplier<?>> supplierClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<OptionalValueSupplier<?>> emptyConstructor = supplierClass.getDeclaredConstructor(new Class[0]);
        emptyConstructor.setAccessible(true);
        OptionalValueSupplier<?> valueSupplier = emptyConstructor.newInstance(new Object[0]);
        if (!TypeUtility.matches(valueSupplier.reflectionType(), parameter.getType())) {
            throw new IllegalArgumentException("Optional supplier of value-valueType '" + valueSupplier.reflectionType().getTypeName() + "' doesn't match the optional value valueType '" + parameter.getType().getName() + "'");
        }
        return valueSupplier;
    }

    @NotNull
    public static <S extends Source, T> OptionalValueSupplier<T> deduceOptionalValueSupplier(Imperat<S> imperat, Parameter parameter, Default defaultAnnotation, DefaultProvider provider, OptionalValueSupplier<T> fallback) throws ImperatException {
        if (defaultAnnotation != null) {
            String def = defaultAnnotation.value();
            ParameterType<S, ?> type = imperat.config().getParameterType(TypeWrap.of(parameter.getType()).getType());
            if (type == null) {
                return OptionalValueSupplier.empty(TypeWrap.of(parameter.getType()));
            }
            return OptionalValueSupplier.of(type.fromString(imperat, def));
        }
        if (provider != null) {
            Class<OptionalValueSupplier<?>> supplierClass = provider.value();
            try {
                return AnnotationHelper.getOptionalValueSupplier(parameter, supplierClass);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalAccessError("Optional value suppler class '" + supplierClass.getName() + "' doesn't have an empty accessible constructor !");
            }
        }
        return fallback;
    }

    public static boolean isHelpParameter(Parameter element) {
        return TypeUtility.areRelatedTypes(element.getType(), CommandHelp.class);
    }
}

