/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat;

import dev.velix.imperat.ImperatConfig;
import dev.velix.imperat.annotations.base.element.ParameterElement;
import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.ContextResolverFactory;
import dev.velix.imperat.command.ContextResolverRegistry;
import dev.velix.imperat.command.SourceResolverRegistry;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.command.processors.CommandPostProcessor;
import dev.velix.imperat.command.processors.CommandPreProcessor;
import dev.velix.imperat.command.processors.CommandProcessingChain;
import dev.velix.imperat.command.processors.impl.DefaultProcessors;
import dev.velix.imperat.command.suggestions.SuggestionResolverRegistry;
import dev.velix.imperat.context.Context;
import dev.velix.imperat.context.ParamTypeRegistry;
import dev.velix.imperat.context.ResolvedContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.ContextFactory;
import dev.velix.imperat.exception.CooldownException;
import dev.velix.imperat.exception.InvalidSourceException;
import dev.velix.imperat.exception.InvalidSyntaxException;
import dev.velix.imperat.exception.InvalidUUIDException;
import dev.velix.imperat.exception.NoHelpException;
import dev.velix.imperat.exception.NoHelpPageException;
import dev.velix.imperat.exception.PermissionDeniedException;
import dev.velix.imperat.exception.SelfHandledException;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.exception.ThrowableResolver;
import dev.velix.imperat.help.HelpProvider;
import dev.velix.imperat.placeholders.Placeholder;
import dev.velix.imperat.placeholders.PlaceholderRegistry;
import dev.velix.imperat.resolvers.ContextResolver;
import dev.velix.imperat.resolvers.DependencySupplier;
import dev.velix.imperat.resolvers.PermissionResolver;
import dev.velix.imperat.resolvers.SourceResolver;
import dev.velix.imperat.resolvers.SuggestionResolver;
import dev.velix.imperat.util.ImperatDebugger;
import dev.velix.imperat.util.Preconditions;
import dev.velix.imperat.util.Registry;
import dev.velix.imperat.verification.UsageVerifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImperatConfigImpl<S extends Source>
implements ImperatConfig<S> {
    @NotNull
    private PermissionResolver<S> permissionResolver = (source, permission) -> true;
    @NotNull
    private ContextFactory<S> contextFactory;
    @NotNull
    private UsageVerifier<S> verifier;
    @Nullable
    private HelpProvider<S> provider = null;
    private final Registry<Type, DependencySupplier> dependencyResolverRegistry = new Registry();
    private final ContextResolverRegistry<S> contextResolverRegistry;
    private final ParamTypeRegistry<S> paramTypeRegistry;
    private final SuggestionResolverRegistry<S> suggestionResolverRegistry;
    private final PlaceholderRegistry<S> placeholderRegistry;
    private final SourceResolverRegistry<S> sourceResolverRegistry;
    private final Map<Class<? extends Throwable>, ThrowableResolver<?, S>> handlers = new HashMap();
    @NotNull
    private CommandProcessingChain<S, CommandPreProcessor<S>> globalPreProcessors;
    @NotNull
    private CommandProcessingChain<S, CommandPostProcessor<S>> globalPostProcessors;
    private String commandPrefix = "/";

    ImperatConfigImpl() {
        this.contextResolverRegistry = ContextResolverRegistry.createDefault(this);
        this.paramTypeRegistry = ParamTypeRegistry.createDefault();
        this.suggestionResolverRegistry = SuggestionResolverRegistry.createDefault(this);
        this.sourceResolverRegistry = SourceResolverRegistry.createDefault();
        this.placeholderRegistry = PlaceholderRegistry.createDefault(this);
        this.contextFactory = ContextFactory.defaultFactory(this);
        this.verifier = UsageVerifier.typeTolerantVerifier();
        this.regDefThrowableResolvers();
        this.globalPreProcessors = CommandProcessingChain.preProcessors().then(DefaultProcessors.preUsagePermission()).then(DefaultProcessors.preUsageCooldown()).build();
        this.globalPostProcessors = CommandProcessingChain.postProcessors().build();
    }

    private void regDefThrowableResolvers() {
        this.setThrowableResolver(InvalidSourceException.class, (exception, imperat, context) -> {
            throw new UnsupportedOperationException("Couldn't find any source resolver for valueType `" + exception.getTargetType().getTypeName() + "'");
        });
        this.setThrowableResolver(SourceException.class, (exception, imperat, context) -> {
            String msg = exception.getMessage();
            switch (exception.getType()) {
                case SEVERE: {
                    context.source().error(msg);
                    break;
                }
                case WARN: {
                    context.source().warn(msg);
                    break;
                }
                case REPLY: {
                    context.source().reply(msg);
                }
            }
        });
        this.setThrowableResolver(InvalidUUIDException.class, (exception, imperat, context) -> context.source().error("Invalid uuid-format '" + exception.getRaw() + "'"));
        this.setThrowableResolver(CooldownException.class, (exception, imperat, context) -> {
            long lastTimeExecuted = exception.getCooldown();
            long timePassed = System.currentTimeMillis() - lastTimeExecuted;
            long remaining = exception.getDefaultCooldown() - timePassed;
            context.source().error("Please wait %d second(s) to execute this command again!".formatted(remaining));
        });
        this.setThrowableResolver(PermissionDeniedException.class, (exception, imperat, context) -> context.source().error("You don't have permission to use this command!"));
        this.setThrowableResolver(InvalidSyntaxException.class, (exception, imperat, context) -> {
            ResolvedContext resolvedContext;
            Object source = context.source();
            if (!(context instanceof ResolvedContext) || (resolvedContext = (ResolvedContext)context).getDetectedUsage() == null) {
                source.error("Unknown command, usage '<raw_args>' is unknown.".replace("<raw_args>", context.arguments().join(" ")));
                return;
            }
            CommandUsage usage = resolvedContext.getDetectedUsage();
            int last = context.arguments().size() - 1;
            List<CommandParameter> params = new ArrayList(usage.getParameters()).stream().filter(param -> !param.isOptional() && param.position() > last).toList();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < params.size(); ++i) {
                CommandParameter param2 = params.get(i);
                assert (!param2.isOptional());
                builder.append(param2.format());
                if (i == params.size() - 1) continue;
                builder.append(' ');
            }
            source.error("Missing required arguments '<required_args>'\n Full syntax: '<usage>'".replace("<required_args>", builder.toString()).replace("<usage>", imperat.commandPrefix() + CommandUsage.format(resolvedContext.command(), usage)));
        });
        this.setThrowableResolver(NoHelpException.class, (exception, imperat, context) -> {
            Command cmdUsed;
            if (context instanceof ResolvedContext) {
                ResolvedContext resolvedContext = (ResolvedContext)context;
                cmdUsed = resolvedContext.getLastUsedCommand();
            } else {
                cmdUsed = context.command();
            }
            assert (cmdUsed != null);
            context.source().error("No Help available for '<command>'".replace("<command>", cmdUsed.name()));
        });
        this.setThrowableResolver(NoHelpPageException.class, (exception, imperat, context) -> {
            ResolvedContext resolvedContext;
            if (!(context instanceof ResolvedContext) || (resolvedContext = (ResolvedContext)context).getDetectedUsage() == null || resolvedContext.getDetectedUsage().isHelp()) {
                throw new IllegalCallerException("Called NoHelpPageCaption in wrong the wrong sequence/part of the code");
            }
            int page = resolvedContext.getArgumentOr("page", 1);
            context.source().error("Page '<page>' doesn't exist!".replace("<page>", String.valueOf(page)));
        });
    }

    @Override
    public String commandPrefix() {
        return this.commandPrefix;
    }

    @Override
    public void setCommandPrefix(String cmdPrefix) {
        this.commandPrefix = cmdPrefix;
    }

    @Override
    public void setPreProcessorsChain(CommandProcessingChain<S, CommandPreProcessor<S>> chain) {
        Preconditions.notNull(chain, "pre-processors chain");
        this.globalPreProcessors = chain;
    }

    @Override
    public void setPostProcessorsChain(CommandProcessingChain<S, CommandPostProcessor<S>> chain) {
        Preconditions.notNull(chain, "post-processors chain");
        this.globalPostProcessors = chain;
    }

    @Override
    public CommandProcessingChain<S, CommandPreProcessor<S>> getPreProcessors() {
        return this.globalPreProcessors;
    }

    @Override
    public CommandProcessingChain<S, CommandPostProcessor<S>> getPostProcessors() {
        return this.globalPostProcessors;
    }

    @Override
    @NotNull
    public PermissionResolver<S> getPermissionResolver() {
        return this.permissionResolver;
    }

    @Override
    public void setPermissionResolver(@NotNull PermissionResolver<S> permissionResolver) {
        this.permissionResolver = permissionResolver;
    }

    @Override
    @NotNull
    public ContextFactory<S> getContextFactory() {
        return this.contextFactory;
    }

    @Override
    public void setContextFactory(@NotNull ContextFactory<S> contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Override
    public boolean hasContextResolver(Type type) {
        return this.getContextResolver(type) != null;
    }

    @Override
    public <T> void registerContextResolverFactory(Type type, ContextResolverFactory<S, T> factory) {
        this.contextResolverRegistry.registerFactory(type, factory);
    }

    @Override
    @Nullable
    public <T> ContextResolverFactory<S, T> getContextResolverFactory(Type type) {
        return this.contextResolverRegistry.getFactoryFor(type).orElse(null);
    }

    @Override
    @Nullable
    public <T> ContextResolver<S, T> getContextResolver(Type resolvingContextType) {
        return this.contextResolverRegistry.getResolverWithoutParameterElement(resolvingContextType);
    }

    @Override
    @Nullable
    public <T> ContextResolver<S, T> getMethodParamContextResolver(@NotNull ParameterElement element) {
        Preconditions.notNull(element, "element");
        return this.contextResolverRegistry.getContextResolver(element.getType(), element);
    }

    @Override
    public <T> void registerContextResolver(Type type, @NotNull ContextResolver<S, T> resolver) {
        this.contextResolverRegistry.registerResolver(type, resolver);
    }

    @Override
    public <T> void registerParamType(Type type, @NotNull ParameterType<S, T> resolver) {
        this.paramTypeRegistry.registerResolver(type, resolver);
    }

    @Override
    @Nullable
    public ParameterType<S, ?> getParameterType(Type resolvingValueType) {
        return this.paramTypeRegistry.getResolver(resolvingValueType).orElse(null);
    }

    @Override
    @Nullable
    public SuggestionResolver<S> getSuggestionResolverByType(Type type) {
        return this.paramTypeRegistry.getResolver(type).map(ParameterType::getSuggestionResolver).orElse(null);
    }

    @Override
    @Nullable
    public SuggestionResolver<S> getNamedSuggestionResolver(String name) {
        return this.suggestionResolverRegistry.getResolverByName(name);
    }

    @Override
    public void registerNamedSuggestionResolver(String name, SuggestionResolver<S> suggestionResolver) {
        this.suggestionResolverRegistry.registerNamedResolver(name.toLowerCase(), suggestionResolver);
    }

    @Override
    public void registerPlaceholder(Placeholder<S> placeholder) {
        this.placeholderRegistry.setData(placeholder.id(), placeholder);
    }

    @Override
    public Optional<Placeholder<S>> getPlaceHolder(String id) {
        return this.placeholderRegistry.getData(id);
    }

    @Override
    @NotNull
    public String replacePlaceholders(String input) {
        return this.placeholderRegistry.resolvedString(input);
    }

    @Override
    @NotNull
    public String[] replacePlaceholders(String[] array) {
        return this.placeholderRegistry.resolvedArray(array);
    }

    @Override
    @Nullable
    public <R> SourceResolver<S, R> getSourceResolver(Type type) {
        return this.sourceResolverRegistry.getData(type).orElse(null);
    }

    @Override
    public <R> void registerSourceResolver(Type type, SourceResolver<S, R> sourceResolver) {
        this.sourceResolverRegistry.setData(type, sourceResolver);
    }

    @Override
    public void setUsageVerifier(UsageVerifier<S> usageVerifier) {
        this.verifier = usageVerifier;
    }

    @Override
    public void registerDependencyResolver(Type type, DependencySupplier resolver) {
        this.dependencyResolverRegistry.setData(type, resolver);
    }

    @Override
    @Nullable
    public <T> T resolveDependency(Type type) {
        return this.dependencyResolverRegistry.getData(type).map(Supplier::get).orElse(null);
    }

    @Override
    public UsageVerifier<S> getUsageVerifier() {
        return this.verifier;
    }

    @Override
    @Nullable
    public HelpProvider<S> getHelpProvider() {
        return this.provider;
    }

    @Override
    public void setHelpProvider(@Nullable HelpProvider<S> template) {
        this.provider = template;
    }

    @Override
    @Nullable
    public <T extends Throwable> ThrowableResolver<T, S> getThrowableResolver(Class<T> exception) {
        for (Class<T> current = exception; current != null && Throwable.class.isAssignableFrom(current); current = current.getSuperclass()) {
            ThrowableResolver<?, S> resolver = this.handlers.get(current);
            if (resolver == null) continue;
            return resolver;
        }
        return null;
    }

    @Override
    public <T extends Throwable> void setThrowableResolver(Class<T> exception, ThrowableResolver<T, S> handler) {
        this.handlers.put(exception, handler);
    }

    @Override
    public void handleThrowable(@NotNull Throwable throwable, Context<S> context, Class<?> owning, String methodName) {
        for (Throwable current = throwable; current != null; current = current.getCause()) {
            if (current instanceof SelfHandledException) {
                SelfHandledException selfHandledException = (SelfHandledException)current;
                selfHandledException.handle(this, context);
                return;
            }
            ThrowableResolver<?, S> handler = this.getThrowableResolver(current.getClass());
            if (handler == null) continue;
            handler.resolve(current, this, context);
            return;
        }
        ImperatDebugger.error(owning, methodName, throwable);
    }
}

