/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.ImperatConfig;
import dev.velix.imperat.ImperatConfigImpl;
import dev.velix.imperat.command.ContextResolverFactory;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.command.processors.CommandPostProcessor;
import dev.velix.imperat.command.processors.CommandPreProcessor;
import dev.velix.imperat.command.processors.CommandProcessingChain;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.ContextFactory;
import dev.velix.imperat.exception.ThrowableResolver;
import dev.velix.imperat.help.HelpProvider;
import dev.velix.imperat.placeholders.Placeholder;
import dev.velix.imperat.resolvers.ContextResolver;
import dev.velix.imperat.resolvers.DependencySupplier;
import dev.velix.imperat.resolvers.PermissionResolver;
import dev.velix.imperat.resolvers.SourceResolver;
import dev.velix.imperat.resolvers.SuggestionResolver;
import dev.velix.imperat.verification.UsageVerifier;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigBuilder<S extends Source, I extends Imperat<S>> {
    protected final ImperatConfig<S> config = new ImperatConfigImpl();

    ConfigBuilder() {
    }

    public ConfigBuilder<S, I> commandPrefix(String cmdPrefix) {
        this.config.setCommandPrefix(cmdPrefix);
        return this;
    }

    public ConfigBuilder<S, I> permissionResolver(PermissionResolver<S> permissionResolver) {
        this.config.setPermissionResolver(permissionResolver);
        return this;
    }

    public ConfigBuilder<S, I> contextFactory(ContextFactory<S> contextFactory) {
        this.config.setContextFactory(contextFactory);
        return this;
    }

    public ConfigBuilder<S, I> usageVerifier(UsageVerifier<S> usageVerifier) {
        this.config.setUsageVerifier(usageVerifier);
        return this;
    }

    public ConfigBuilder<S, I> dependencyResolver(Type type, DependencySupplier resolver) {
        this.config.registerDependencyResolver(type, resolver);
        return this;
    }

    public <T extends Throwable> ConfigBuilder<S, I> throwableResolver(Class<T> exception, ThrowableResolver<T, S> handler) {
        this.config.setThrowableResolver(exception, handler);
        return this;
    }

    public ConfigBuilder<S, I> preProcessor(CommandPreProcessor<S> preProcessor) {
        this.config.getPreProcessors().add(preProcessor);
        return this;
    }

    public ConfigBuilder<S, I> postProcessor(CommandPostProcessor<S> postProcessor) {
        this.config.getPostProcessors().add(postProcessor);
        return this;
    }

    public ConfigBuilder<S, I> preProcessingChain(CommandProcessingChain<S, CommandPreProcessor<S>> chain) {
        this.config.setPreProcessorsChain(chain);
        return this;
    }

    public ConfigBuilder<S, I> postProcessingChain(CommandProcessingChain<S, CommandPostProcessor<S>> chain) {
        this.config.setPostProcessorsChain(chain);
        return this;
    }

    public <T> ConfigBuilder<S, I> contextResolverFactory(Type type, ContextResolverFactory<S, T> factory) {
        this.config.registerContextResolverFactory(type, factory);
        return this;
    }

    public <T> ConfigBuilder<S, I> contextResolver(Type type, ContextResolver<S, T> resolver) {
        this.config.registerContextResolver(type, resolver);
        return this;
    }

    public <T> ConfigBuilder<S, I> parameterType(Type type, ParameterType<S, T> resolver) {
        this.config.registerParamType(type, resolver);
        return this;
    }

    public ConfigBuilder<S, I> namedSuggestionResolver(String name, SuggestionResolver<S> suggestionResolver) {
        this.config.registerNamedSuggestionResolver(name, suggestionResolver);
        return this;
    }

    public <R> ConfigBuilder<S, I> sourceResolver(Type type, SourceResolver<S, R> sourceResolver) {
        this.config.registerSourceResolver(type, sourceResolver);
        return this;
    }

    public ConfigBuilder<S, I> placeholder(Placeholder<S> placeholder) {
        this.config.registerPlaceholder(placeholder);
        return this;
    }

    public ConfigBuilder<S, I> helpProvider(HelpProvider<S> helpProvider) {
        this.config.setHelpProvider(helpProvider);
        return this;
    }

    @NotNull
    public abstract I build();
}

