/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.type;

import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.type.BaseParameterType;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.SuggestionContext;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.UnknownPlayerException;
import dev.velix.imperat.resolvers.SuggestionResolver;
import dev.velix.imperat.util.TypeWrap;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterPlayer
extends BaseParameterType<BukkitSource, Player> {
    private final PlayerSuggestionResolver SUGGESTION_RESOLVER = new PlayerSuggestionResolver();

    public ParameterPlayer() {
        super(TypeWrap.of(Player.class));
    }

    @Nullable
    public Player resolve(@NotNull ExecutionContext<BukkitSource> context, @NotNull CommandInputStream<BukkitSource> commandInputStream) throws ImperatException {
        String raw = commandInputStream.currentRaw().orElse(null);
        if (raw == null) {
            return null;
        }
        if (raw.equalsIgnoreCase("me")) {
            if (((BukkitSource)context.source()).isConsole()) {
                throw new UnknownPlayerException(raw);
            }
            return ((BukkitSource)context.source()).asPlayer();
        }
        Player player = Bukkit.getPlayer((String)raw.toLowerCase());
        if (player != null) {
            return player;
        }
        throw new UnknownPlayerException(raw);
    }

    public boolean matchesInput(String input, CommandParameter<BukkitSource> parameter) {
        return input.length() <= 16;
    }

    @NotNull
    public Player fromString(Imperat<BukkitSource> imperat, String input) throws ImperatException {
        return Objects.requireNonNull(Bukkit.getPlayer((String)input));
    }

    public SuggestionResolver<BukkitSource> getSuggestionResolver() {
        return this.SUGGESTION_RESOLVER;
    }

    private static final class PlayerSuggestionResolver
    implements SuggestionResolver<BukkitSource> {
        private PlayerSuggestionResolver() {
        }

        public List<String> autoComplete(SuggestionContext<BukkitSource> context, CommandParameter<BukkitSource> parameter) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
        }
    }
}

