/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.type;

import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.parameters.type.BaseParameterType;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.util.TypeUtility;
import dev.velix.imperat.util.TypeWrap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterLocation
extends BaseParameterType<BukkitSource, Location> {
    private static final String SINGLE_STRING_SEPARATOR = ";";

    public ParameterLocation() {
        super(TypeWrap.of(Location.class));
    }

    @Nullable
    public Location resolve(@NotNull ExecutionContext<BukkitSource> context, @NotNull CommandInputStream<BukkitSource> stream) throws ImperatException {
        try {
            String currentRaw = (String)stream.currentRaw().orElseThrow();
            return this.fromString((Imperat<BukkitSource>)context.imperat(), currentRaw);
        }
        catch (Exception ex) {
            World world;
            String currentRaw = (String)stream.currentRaw().orElseThrow();
            if (!TypeUtility.isNumber((String)currentRaw) && Bukkit.getWorld((String)currentRaw) != null) {
                world = Bukkit.getWorld((String)currentRaw);
                stream.skipRaw();
            } else if (((BukkitSource)context.source()).isConsole()) {
                List worlds = Bukkit.getWorlds();
                if (worlds.isEmpty()) {
                    throw new SourceException(SourceException.ErrorLevel.SEVERE, "Failed to fetch the world of the given location", new Object[0]);
                }
                world = (World)Bukkit.getWorlds().get(0);
            } else {
                world = ((BukkitSource)context.source()).asPlayer().getWorld();
            }
            ParameterType doubleParser = context.imperatConfig().getParameterType(Double.class);
            if (doubleParser == null) {
                throw new SourceException(SourceException.ErrorLevel.SEVERE, "Failed to find a parser for type '%s'", new Object[]{Double.class.getTypeName()});
            }
            Double x = (Double)doubleParser.resolve(context, stream);
            if (x == null) {
                throw new SourceException(SourceException.ErrorLevel.SEVERE, "X coordinate is invalid", new Object[0]);
            }
            stream.skipRaw();
            Double y = (Double)doubleParser.resolve(context, stream);
            if (y == null) {
                throw new SourceException(SourceException.ErrorLevel.SEVERE, "Y coordinate is invalid", new Object[0]);
            }
            stream.skipRaw();
            Double z = (Double)doubleParser.resolve(context, stream);
            if (z == null) {
                throw new SourceException(SourceException.ErrorLevel.SEVERE, "Z coordinate is invalid", new Object[0]);
            }
            return new Location(world, x.doubleValue(), y.doubleValue(), z.doubleValue());
        }
    }

    @NotNull
    public Location fromString(Imperat<BukkitSource> imperat, String currentRaw) throws ImperatException {
        String[] split = currentRaw.split(SINGLE_STRING_SEPARATOR);
        if (split.length < 4) {
            throw new IllegalArgumentException();
        }
        World world = Bukkit.getWorld((String)split[0]);
        if (world == null) {
            throw new IllegalArgumentException();
        }
        ParameterType doubleParser = imperat.config().getParameterType(Double.class);
        if (doubleParser == null) {
            throw new IllegalArgumentException();
        }
        Double x = (Double)doubleParser.fromString(imperat, split[1]);
        Double y = (Double)doubleParser.fromString(imperat, split[2]);
        Double z = (Double)doubleParser.fromString(imperat, split[3]);
        if (x == null || y == null || z == null) {
            throw new SourceException(SourceException.ErrorLevel.SEVERE, "Failed to parse location from input '%s'", new Object[]{currentRaw});
        }
        return new Location(world, x.doubleValue(), y.doubleValue(), z.doubleValue());
    }
}

