/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.selector.field.filters;

import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.selector.EntityCondition;
import dev.velix.imperat.selector.field.filters.PredicateField;
import dev.velix.imperat.util.TypeWrap;
import java.util.Arrays;
import org.bukkit.GameMode;
import org.bukkit.entity.HumanEntity;
import org.jetbrains.annotations.NotNull;

final class GamemodeField
extends PredicateField<GameMode> {
    GamemodeField(String name) {
        super(name, TypeWrap.of(GameMode.class));
        Arrays.stream(GameMode.values()).map(Enum::name).map(String::toLowerCase).forEach(this.suggestions::add);
    }

    @Override
    @NotNull
    protected EntityCondition getCondition(GameMode value, CommandInputStream<BukkitSource> commandInputStream) {
        return (sender, entity) -> {
            if (!(entity instanceof HumanEntity)) {
                return false;
            }
            HumanEntity humanEntity = (HumanEntity)entity;
            return humanEntity.getGameMode() == value;
        };
    }

    @Override
    public GameMode parseFieldValue(String value) throws ImperatException {
        try {
            return GameMode.valueOf((String)value);
        }
        catch (EnumConstantNotPresentException ex) {
            throw new SourceException("Unknown gamemode '%s'", new Object[]{value});
        }
    }
}

