/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.selector.field.filters;

import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.selector.EntityCondition;
import dev.velix.imperat.selector.field.NumericField;
import dev.velix.imperat.selector.field.Range;
import dev.velix.imperat.selector.field.RangedNumericField;
import dev.velix.imperat.selector.field.filters.PredicateField;
import dev.velix.imperat.util.ImperatDebugger;
import dev.velix.imperat.util.TypeWrap;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

final class DistanceField
extends PredicateField<Range<Double>> {
    private final RangedNumericField<Double> rangedNumericField;

    DistanceField(String name) {
        super(name, new TypeWrap<Range<Double>>(){});
        this.rangedNumericField = RangedNumericField.of(NumericField.doubleField(name));
    }

    @Override
    @NotNull
    protected EntityCondition getCondition(Range<Double> value, CommandInputStream<BukkitSource> commandInputStream) {
        return (sender, entity) -> {
            if (sender.isConsole()) {
                throw new SourceException("Only players can use the field=`distance`", new Object[0]);
            }
            Player commandSource = sender.asPlayer();
            double diffInDistance = commandSource.getLocation().distance(entity.getLocation());
            ImperatDebugger.debug((String)"Min=%s, Double value=%s", (Object[])new Object[]{value.getMin(), diffInDistance});
            return value.isInRange(diffInDistance);
        };
    }

    @Override
    public Range<Double> parseFieldValue(String value) throws ImperatException {
        return this.rangedNumericField.parseFieldValue(value);
    }
}

