/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.selector.field;

import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.selector.field.AbstractField;
import dev.velix.imperat.util.TypeUtility;
import dev.velix.imperat.util.TypeWrap;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class NumericField<N extends Number>
extends AbstractField<N> {
    protected NumericField(String name, TypeWrap<N> type) {
        super(name, type);
    }

    @Override
    public N parseFieldValue(String value) throws ImperatException {
        return this.parseNumber(value);
    }

    protected abstract N parseNumber(String var1) throws ImperatException;

    public static NumericField<Integer> integerField(String name) {
        return new IntegerField(name);
    }

    public static NumericField<Double> doubleField(String name) {
        return new DoubleField(name);
    }

    public static NumericField<Float> floatField(String name) {
        return new FloatField(name);
    }

    public static NumericField<Long> longField(String name) {
        return new LongField(name);
    }

    public static NumericField<Short> shortField(String name) {
        return new ShortField(name);
    }

    public static NumericField<Byte> byteField(String name) {
        return new ByteField(name);
    }

    static final class IntegerField
    extends NumericField<Integer> {
        public IntegerField(String name) {
            super(name, TypeWrap.of(Integer.class));
        }

        @Override
        public Integer parseNumber(String value) throws ImperatException {
            if (!TypeUtility.isInteger((String)value)) {
                throw new SourceException("Invalid limit-value integer '%s'", new Object[]{value});
            }
            return Integer.parseInt(value);
        }
    }

    static final class DoubleField
    extends NumericField<Double> {
        public DoubleField(String name) {
            super(name, TypeWrap.of(Double.class));
        }

        @Override
        public Double parseNumber(String value) throws ImperatException {
            if (!TypeUtility.isDouble((String)value)) {
                throw new SourceException("Invalid double value '%s'", new Object[]{value});
            }
            return Double.parseDouble(value);
        }
    }

    static final class FloatField
    extends NumericField<Float> {
        public FloatField(String name) {
            super(name, TypeWrap.of(Float.class));
        }

        @Override
        public Float parseNumber(String value) throws ImperatException {
            if (!TypeUtility.isFloat((String)value)) {
                throw new SourceException("Invalid float value '%s'", new Object[]{value});
            }
            return Float.valueOf(Float.parseFloat(value));
        }
    }

    static final class LongField
    extends NumericField<Long> {
        public LongField(String name) {
            super(name, TypeWrap.of(Long.class));
        }

        @Override
        public Long parseNumber(String value) throws ImperatException {
            if (!TypeUtility.isLong((String)value)) {
                throw new SourceException("Invalid long value '%s'", new Object[]{value});
            }
            return Long.parseLong(value);
        }
    }

    static final class ShortField
    extends NumericField<Short> {
        public ShortField(String name) {
            super(name, TypeWrap.of(Short.class));
        }

        @Override
        public Short parseNumber(String value) throws ImperatException {
            if (!TypeUtility.isShort((String)value)) {
                throw new SourceException("Invalid short value '%s'", new Object[]{value});
            }
            return Short.parseShort(value);
        }
    }

    static final class ByteField
    extends NumericField<Byte> {
        public ByteField(String name) {
            super(name, TypeWrap.of(Byte.class));
        }

        @Override
        public Byte parseNumber(String value) throws ImperatException {
            if (!TypeUtility.isByte((String)value)) {
                throw new SourceException("Invalid byte value '%s'", new Object[]{value});
            }
            return Byte.parseByte(value);
        }
    }
}

