/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.brigadier;

import dev.velix.imperat.BaseBrigadierManager;
import dev.velix.imperat.BukkitImperat;
import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.Imperat;
import dev.velix.imperat.brigadier.DefaultArgTypeResolvers;
import dev.velix.imperat.command.Command;
import dev.velix.imperat.commodore.Commodore;
import dev.velix.imperat.commodore.CommodoreProvider;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.resolvers.PermissionResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public final class BukkitBrigadierManager
extends BaseBrigadierManager<BukkitSource> {
    private final Commodore<org.bukkit.command.Command> commodore;

    public BukkitBrigadierManager(BukkitImperat dispatcher) {
        super((Imperat)dispatcher);
        this.commodore = CommodoreProvider.getCommodore(dispatcher.getPlatform());
        if (CommodoreProvider.isSupported()) {
            this.registerArgumentResolver(String.class, DefaultArgTypeResolvers.STRING);
            this.registerArgumentResolver(DefaultArgTypeResolvers.NUMERIC);
            this.registerArgumentResolver(Boolean.class, DefaultArgTypeResolvers.BOOLEAN);
            this.registerArgumentResolver(Player.class, DefaultArgTypeResolvers.PLAYER);
            this.registerArgumentResolver(OfflinePlayer.class, DefaultArgTypeResolvers.PLAYER);
            this.registerArgumentResolver(DefaultArgTypeResolvers.ENTITY_SELECTOR);
        }
    }

    @Nullable
    public static BukkitBrigadierManager load(BukkitImperat bukkitCommandDispatcher) {
        if (!CommodoreProvider.isSupported()) {
            return null;
        }
        return new BukkitBrigadierManager(bukkitCommandDispatcher);
    }

    public BukkitSource wrapCommandSource(Object commandSource) {
        return (BukkitSource)this.dispatcher.wrapSender((Object)this.commodore.wrapNMSCommandSource(commandSource));
    }

    public void registerBukkitCommand(org.bukkit.command.Command bukkitCmd, Command<BukkitSource> imperatCommand, PermissionResolver<BukkitSource> resolver) {
        this.commodore.register(bukkitCmd, this.parseCommandIntoNode(imperatCommand), player -> resolver.hasPermission((Source)((BukkitSource)this.dispatcher.wrapSender(player)), bukkitCmd.getPermission()));
    }
}

