/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat;

import dev.velix.imperat.BukkitImperat;
import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.util.ImperatDebugger;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class InternalBukkitCommand
extends org.bukkit.command.Command
implements PluginIdentifiableCommand {
    @NotNull
    private final BukkitImperat dispatcher;
    @NotNull
    final Command<BukkitSource> imperatCommand;

    InternalBukkitCommand(@NotNull BukkitImperat dispatcher, @NotNull Command<BukkitSource> imperatCommand) {
        super(imperatCommand.name(), imperatCommand.description().toString(), CommandUsage.format((String)null, (CommandUsage)imperatCommand.getDefaultUsage()), imperatCommand.aliases());
        this.dispatcher = dispatcher;
        this.imperatCommand = imperatCommand;
    }

    @NotNull
    public Plugin getPlugin() {
        return this.dispatcher.getPlatform();
    }

    @Nullable
    public String getPermission() {
        return this.imperatCommand.permission();
    }

    @NotNull
    public String getDescription() {
        return super.getDescription();
    }

    @NotNull
    public String getUsage() {
        return super.getUsage();
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String label, String[] raw) {
        try {
            BukkitSource source = this.dispatcher.wrapSender(sender);
            this.dispatcher.dispatch(source, this.imperatCommand, label, raw);
            return true;
        }
        catch (Exception ex) {
            ImperatDebugger.error(InternalBukkitCommand.class, (String)"execute", (Throwable)ex);
            return false;
        }
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String[] args) throws IllegalArgumentException {
        BukkitSource source = this.dispatcher.wrapSender(sender);
        try {
            return (List)this.dispatcher.autoComplete(this.imperatCommand, source, alias, args).join();
        }
        catch (Exception ex) {
            ImperatDebugger.error(InternalBukkitCommand.class, (String)"tabComplete", (Throwable)ex);
            return Collections.emptyList();
        }
    }
}

