/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat;

import dev.velix.imperat.BukkitImperat;
import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.Imperat;
import dev.velix.imperat.InternalBukkitCommand;
import dev.velix.imperat.context.ArgumentQueue;
import dev.velix.imperat.context.Context;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.ResolvedContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.ContextFactory;
import dev.velix.imperat.help.CommandHelp;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.help.GenericCommandHelpTopic;
import org.bukkit.help.HelpTopic;
import org.bukkit.help.HelpTopicFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImperatBukkitHelpTopic
extends GenericCommandHelpTopic {
    private final BukkitImperat imperat;

    public ImperatBukkitHelpTopic(InternalBukkitCommand command, BukkitImperat bukkitImperat) {
        super((Command)command);
        this.imperat = bukkitImperat;
        ContextFactory factory = this.imperat.config.getContextFactory();
        ArrayList<String> messages = new ArrayList<String>();
        HelpSource source = new HelpSource(this.imperat.wrapSender(Bukkit.getConsoleSender()), messages);
        Context context = factory.createContext((Imperat)this.imperat, (Source)source, command.imperatCommand, command.imperatCommand.name(), ArgumentQueue.empty());
        ResolvedContext resolvedContext = factory.createResolvedContext(context, command.imperatCommand.getDefaultUsage());
        CommandHelp commandHelp = new CommandHelp(this.imperat.config, (ExecutionContext)resolvedContext);
        commandHelp.display((Source)source);
        this.fullText = String.join((CharSequence)"\n", messages);
    }

    @NotNull
    public String getFullText(@NotNull CommandSender sender) {
        return super.getFullText(sender);
    }

    public boolean canSee(@NotNull CommandSender sender) {
        return this.imperat.config.getPermissionResolver().hasPermission((Source)this.imperat.wrapSender(sender), this.command.getPermission());
    }

    static class HelpSource
    extends BukkitSource {
        private final List<String> messages;
        private final LegacyComponentSerializer componentSerializer = LegacyComponentSerializer.legacySection();

        protected HelpSource(BukkitSource source, List<String> messages) {
            super(source.sender, source.provider);
            this.messages = messages;
        }

        @Override
        public void reply(String message) {
            this.messages.add(message);
        }

        @Override
        public void reply(ComponentLike component) {
            this.messages.add(this.componentSerializer.serialize(component.asComponent()));
        }
    }

    static class Factory
    implements HelpTopicFactory<InternalBukkitCommand> {
        private final BukkitImperat imperat;

        Factory(BukkitImperat imperat) {
            this.imperat = imperat;
        }

        @Nullable
        public HelpTopic createTopic(@NotNull InternalBukkitCommand internalBukkitCommand) {
            return new ImperatBukkitHelpTopic(internalBukkitCommand, this.imperat);
        }
    }
}

