/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat;

import dev.velix.imperat.BaseImperat;
import dev.velix.imperat.BukkitConfigBuilder;
import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.ImperatBukkitHelpTopic;
import dev.velix.imperat.ImperatConfig;
import dev.velix.imperat.InternalBukkitCommand;
import dev.velix.imperat.adventure.AdventureProvider;
import dev.velix.imperat.brigadier.BukkitBrigadierManager;
import dev.velix.imperat.command.Command;
import dev.velix.imperat.resolvers.PermissionResolver;
import dev.velix.imperat.util.BukkitUtil;
import dev.velix.imperat.util.ImperatDebugger;
import dev.velix.imperat.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.help.HelpTopicFactory;
import org.bukkit.plugin.Plugin;

public final class BukkitImperat
extends BaseImperat<BukkitSource> {
    private final Plugin plugin;
    private final AdventureProvider<CommandSender> adventureProvider;
    private BukkitBrigadierManager brigadierManager;
    private Map<String, org.bukkit.command.Command> bukkitCommands = new HashMap<String, org.bukkit.command.Command>();

    public static BukkitConfigBuilder builder(Plugin plugin) {
        return new BukkitConfigBuilder(plugin);
    }

    BukkitImperat(Plugin plugin, AdventureProvider<CommandSender> adventureProvider, boolean supportBrigadier, ImperatConfig<BukkitSource> config) {
        super(config);
        this.plugin = plugin;
        this.adventureProvider = adventureProvider;
        ImperatDebugger.setLogger((Logger)plugin.getLogger());
        try {
            if (BukkitUtil.KNOWN_COMMANDS != null) {
                this.bukkitCommands = (Map)BukkitUtil.KNOWN_COMMANDS.get(BukkitUtil.COMMAND_MAP);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (supportBrigadier) {
            this.applyBrigadier();
        }
        Bukkit.getHelpMap().registerHelpTopicFactory(InternalBukkitCommand.class, (HelpTopicFactory)new ImperatBukkitHelpTopic.Factory(this));
    }

    public BukkitSource wrapSender(Object sender) {
        return new BukkitSource((CommandSender)sender, this.adventureProvider);
    }

    public Plugin getPlatform() {
        return this.plugin;
    }

    public void shutdownPlatform() {
        this.adventureProvider.close();
        Bukkit.getPluginManager().disablePlugin(this.plugin);
    }

    public void registerCommand(Command<BukkitSource> command) {
        super.registerCommand(command);
        InternalBukkitCommand internalCmd = new InternalBukkitCommand(this, command);
        BukkitUtil.COMMAND_MAP.register(this.plugin.getName(), (org.bukkit.command.Command)internalCmd);
        if (this.brigadierManager != null) {
            this.brigadierManager.registerBukkitCommand(internalCmd, command, (PermissionResolver<BukkitSource>)this.config.getPermissionResolver());
        }
    }

    public void unregisterCommand(String name) {
        Command imperatCmd = this.getCommand(name);
        super.unregisterCommand(name);
        if (imperatCmd == null) {
            return;
        }
        for (Map.Entry<String, org.bukkit.command.Command> entry : new HashSet<Map.Entry<String, org.bukkit.command.Command>>(this.bukkitCommands.entrySet())) {
            String originalKey = entry.getKey();
            String key = StringUtils.stripNamespace((String)originalKey);
            if (!imperatCmd.hasName(key)) continue;
            this.bukkitCommands.remove(originalKey);
        }
        try {
            if (BukkitUtil.KNOWN_COMMANDS != null) {
                BukkitUtil.KNOWN_COMMANDS.set(BukkitUtil.COMMAND_MAP, this.bukkitCommands);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void unregisterAllCommands() {
        super.unregisterAllCommands();
        if (BukkitUtil.KNOWN_COMMANDS != null) {
            this.bukkitCommands.clear();
            try {
                BukkitUtil.KNOWN_COMMANDS.set(BukkitUtil.COMMAND_MAP, this.bukkitCommands);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void applyBrigadier() {
        this.brigadierManager = BukkitBrigadierManager.load(this);
    }
}

