/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.util;

import dev.velix.imperat.BukkitImperat;
import dev.velix.imperat.util.ImperatDebugger;
import dev.velix.imperat.util.TypeUtility;
import dev.velix.imperat.util.reflection.FieldAccessor;
import dev.velix.imperat.util.reflection.Reflections;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BukkitUtil {
    public static CommandMap COMMAND_MAP;
    @Nullable
    public static Field KNOWN_COMMANDS;

    private BukkitUtil() {
    }

    private static void loadBukkitFieldMappings() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class<?> craftServer = Bukkit.getServer().getClass();
        FieldAccessor accessor = Reflections.getField(craftServer, SimpleCommandMap.class);
        COMMAND_MAP = (CommandMap)accessor.get((Object)Bukkit.getServer());
        if (COMMAND_MAP != null) {
            KNOWN_COMMANDS = SimpleCommandMap.class.getDeclaredField("knownCommands");
            KNOWN_COMMANDS.setAccessible(true);
        }
    }

    public static Class<? extends Entity> getSelectedEntity(@NotNull Type selectorType) {
        return (Class)TypeUtility.getInsideGeneric((Type)selectorType, Entity.class);
    }

    public static <T> Set<T> mergedSet(Set<T> set1, Set<T> set2, Supplier<Set<T>> supplier) {
        Set<T> merged = supplier.get();
        merged.addAll(set1);
        merged.addAll(set2);
        return merged;
    }

    static {
        try {
            BukkitUtil.loadBukkitFieldMappings();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            ImperatDebugger.error(BukkitImperat.class, (String)"static-init", (Throwable)e, (String)"Failed to fetch bukkit command-map, disabling plugin");
        }
    }

    public static final class ClassesRefUtil {
        private static final String SERVER_VERSION = ClassesRefUtil.getServerVersion();

        private ClassesRefUtil() {
        }

        private static String getServerVersion() {
            Class<?> server = Bukkit.getServer().getClass();
            if (!server.getSimpleName().equals("CraftServer")) {
                return ".";
            }
            if (server.getName().equals("org.bukkit.craftbukkit.CraftServer")) {
                return ".";
            }
            String version = server.getName().substring("org.bukkit.craftbukkit".length());
            return version.substring(0, version.length() - "CraftServer".length());
        }

        public static String mc(String name) {
            return "net.minecraft." + name;
        }

        public static String nms(String className) {
            return "net.minecraft.server" + SERVER_VERSION + className;
        }

        public static Class<?> mcClass(String className) throws ClassNotFoundException {
            return Class.forName(ClassesRefUtil.mc(className));
        }

        public static Class<?> nmsClass(String className) throws ClassNotFoundException {
            return Class.forName(ClassesRefUtil.nms(className));
        }

        public static String obc(String className) {
            return "org.bukkit.craftbukkit" + SERVER_VERSION + className;
        }

        public static Class<?> obcClass(String className) throws ClassNotFoundException {
            return Class.forName(ClassesRefUtil.obc(className));
        }

        public static int minecraftVersion() {
            try {
                Matcher matcher = Pattern.compile("\\(MC: (\\d)\\.(\\d+)\\.?(\\d+?)?( .*)?\\)").matcher(Bukkit.getVersion());
                if (matcher.find()) {
                    return Integer.parseInt(matcher.toMatchResult().group(2), 10);
                }
                throw new IllegalArgumentException(String.format("No match found in '%s'", Bukkit.getVersion()));
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("Failed to determine Minecraft version", ex);
            }
        }
    }
}

