/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.type;

import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.type.BaseParameterType;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.SuggestionContext;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.resolvers.SuggestionResolver;
import dev.velix.imperat.selector.EntityCondition;
import dev.velix.imperat.selector.SelectionParameterInput;
import dev.velix.imperat.selector.SelectionType;
import dev.velix.imperat.selector.TargetSelector;
import dev.velix.imperat.selector.field.filters.PredicateField;
import dev.velix.imperat.selector.field.operators.OperatorField;
import dev.velix.imperat.util.TypeWrap;
import dev.velix.imperat.util.Version;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class ParameterTargetSelector
extends BaseParameterType<BukkitSource, TargetSelector> {
    private static final char PARAMETER_START = '[';
    private static final char PARAMETER_END = ']';
    private final SuggestionResolver<BukkitSource> suggestionResolver;

    public ParameterTargetSelector() {
        super(TypeWrap.of(TargetSelector.class));
        SelectionType.TYPES.stream().filter(type -> type != SelectionType.UNKNOWN).map(SelectionType::id).forEach(id -> this.suggestions.add("@" + id));
        this.suggestionResolver = new TargetSelectorSuggestionResolver();
    }

    @NotNull
    public TargetSelector resolve(ExecutionContext<BukkitSource> context, @NotNull CommandInputStream<BukkitSource> commandInputStream) throws ImperatException {
        boolean parameterized;
        String raw = commandInputStream.currentRaw().orElse(null);
        if (raw == null) {
            return TargetSelector.empty();
        }
        if (Version.isOrOver(13)) {
            SelectionType type = commandInputStream.popLetter().map(s -> SelectionType.from(String.valueOf(s))).orElse(SelectionType.UNKNOWN);
            return TargetSelector.of(type, Bukkit.selectEntities((CommandSender)((BukkitSource)context.source()).origin(), (String)raw));
        }
        char last = raw.charAt(raw.length() - 1);
        if (commandInputStream.currentLetter().filter(c -> String.valueOf(c).equalsIgnoreCase("@")).isEmpty()) {
            Player target = Bukkit.getPlayer((String)raw);
            if (target == null) {
                return TargetSelector.empty();
            }
            return TargetSelector.of(SelectionType.UNKNOWN, new Entity[]{target});
        }
        SelectionType type = commandInputStream.popLetter().map(s -> SelectionType.from(String.valueOf(s))).orElse(SelectionType.UNKNOWN);
        if (type == SelectionType.UNKNOWN) {
            throw new SourceException("Unknown selection type '%s'", new Object[]{commandInputStream.currentLetter().orElseThrow()});
        }
        ArrayList<SelectionParameterInput<?>> inputParameters = new ArrayList();
        boolean bl = parameterized = commandInputStream.popLetter().map(c -> c.charValue() == '[').orElse(false) != false && last == ']';
        if (parameterized) {
            commandInputStream.skipLetter();
            String params = commandInputStream.collectBeforeFirst(']');
            inputParameters = SelectionParameterInput.parseAll(params, commandInputStream);
        }
        List entities = type.getTargetEntities(context, commandInputStream);
        ArrayList<Entity> selected = new ArrayList<Entity>();
        EntityCondition entityPredicted = ParameterTargetSelector.getEntityPredicate(commandInputStream, inputParameters);
        for (Entity entity : entities) {
            if (!entityPredicted.test((BukkitSource)context.source(), entity)) continue;
            selected.add(entity);
        }
        ParameterTargetSelector.operateFields(inputParameters, selected);
        return TargetSelector.of(type, selected);
    }

    @NotNull
    private static <V> EntityCondition getEntityPredicate(@NotNull CommandInputStream<BukkitSource> commandInputStream, List<SelectionParameterInput<?>> inputParameters) {
        EntityCondition entityPredicted = (sender, entity) -> true;
        for (SelectionParameterInput<?> input : inputParameters) {
            if (!(input.getField() instanceof PredicateField)) continue;
            PredicateField predicateField = (PredicateField)input.getField();
            entityPredicted = entityPredicted.and((sender, entity) -> predicateField.isApplicable(sender, entity, input.getValue(), commandInputStream));
        }
        return entityPredicted;
    }

    private static <V> void operateFields(List<SelectionParameterInput<?>> inputParameters, List<Entity> selected) {
        for (SelectionParameterInput<?> input : inputParameters) {
            if (!(input.getField() instanceof OperatorField)) continue;
            OperatorField operatorField = (OperatorField)input.getField();
            operatorField.operate(input.getValue(), selected);
        }
    }

    public SuggestionResolver<BukkitSource> getSuggestionResolver() {
        return this.suggestionResolver;
    }

    @NotNull
    public TargetSelector fromString(Imperat<BukkitSource> imperat, String input) {
        return TargetSelector.empty();
    }

    private final class TargetSelectorSuggestionResolver
    implements SuggestionResolver<BukkitSource> {
        private TargetSelectorSuggestionResolver() {
        }

        public List<String> autoComplete(SuggestionContext<BukkitSource> context, CommandParameter<BukkitSource> parameter) {
            ArrayList<String> completions = new ArrayList<String>(ParameterTargetSelector.this.suggestions);
            Bukkit.getOnlinePlayers().stream().map(Player::getName).forEach(completions::add);
            return completions;
        }
    }
}

