/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.selector.field.operators;

import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.selector.field.operators.OperatorField;
import dev.velix.imperat.selector.field.operators.SortOption;
import dev.velix.imperat.util.TypeWrap;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Entity;

final class SortOperatorField
extends OperatorField<SortOption> {
    SortOperatorField(String name) {
        super(name, TypeWrap.of(SortOption.class));
        Arrays.stream(SortOption.values()).map(Enum::name).map(String::toLowerCase).forEach(this.suggestions::add);
    }

    @Override
    public SortOption parseFieldValue(String value) throws ImperatException {
        for (SortOption option : SortOption.values()) {
            if (!option.name().equalsIgnoreCase(this.name)) continue;
            return option;
        }
        throw new SourceException("Unknown sort option '%s'", new Object[]{this.name});
    }

    @Override
    public void operate(SortOption value, List<Entity> entities) {
        value.sort(entities);
    }
}

