/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.selector.field.filters;

import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.selector.EntityCondition;
import dev.velix.imperat.selector.field.filters.PredicateField;
import dev.velix.imperat.util.TypeWrap;
import java.util.Arrays;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

final class TypeField
extends PredicateField<EntityType> {
    TypeField(String name) {
        super(name, TypeWrap.of(EntityType.class));
        Arrays.stream(EntityType.values()).map(Enum::name).map(String::toLowerCase).forEach(this.suggestions::add);
    }

    @Override
    @NotNull
    protected EntityCondition getCondition(EntityType value, CommandInputStream<BukkitSource> commandInputStream) {
        return (sender, entity) -> entity.getType() == value;
    }

    @Override
    public EntityType parseFieldValue(String value) throws ImperatException {
        try {
            return EntityType.valueOf((String)value.toUpperCase());
        }
        catch (EnumConstantNotPresentException ex) {
            throw new SourceException("Unknown type '%s'", new Object[]{value});
        }
    }
}

