/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.selector.field.filters;

import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.selector.EntityCondition;
import dev.velix.imperat.selector.field.NumericField;
import dev.velix.imperat.selector.field.Range;
import dev.velix.imperat.selector.field.RangedNumericField;
import dev.velix.imperat.selector.field.filters.PredicateField;
import dev.velix.imperat.util.TypeWrap;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

final class LevelField
extends PredicateField<Range<Integer>> {
    private final RangedNumericField<Integer> numericField;

    LevelField(String name) {
        super(name, new TypeWrap<Range<Integer>>(){});
        this.numericField = RangedNumericField.of(NumericField.integerField(name));
    }

    @Override
    @NotNull
    protected EntityCondition getCondition(Range<Integer> value, CommandInputStream<BukkitSource> commandInputStream) {
        return (sender, entity) -> {
            if (!(entity instanceof Player)) {
                return false;
            }
            Player humanEntity = (Player)entity;
            return value.isInRange(humanEntity.getLevel());
        };
    }

    @Override
    public Range<Integer> parseFieldValue(String value) throws ImperatException {
        return this.numericField.parseFieldValue(value);
    }
}

