/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.selector.field;

import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.selector.field.AbstractField;
import dev.velix.imperat.selector.field.NumericField;
import dev.velix.imperat.selector.field.Range;
import dev.velix.imperat.util.ImperatDebugger;
import dev.velix.imperat.util.TypeUtility;
import dev.velix.imperat.util.TypeWrap;

public final class RangedNumericField<N extends Number>
extends AbstractField<Range<N>> {
    private static final String RANGE_CHARACTER = "\\.\\.";
    private static final String RANGE_CHARACTER_WITHOUT_ESCAPE = "..";
    private final NumericField<N> numericField;

    private RangedNumericField(NumericField<N> numericField) {
        super(numericField.name, new TypeWrap<Range<N>>(){});
        this.numericField = numericField;
    }

    public static <N extends Number> RangedNumericField<N> of(NumericField<N> numericField) {
        return new RangedNumericField<N>(numericField);
    }

    @Override
    public Range<N> parseFieldValue(String value) throws ImperatException {
        ImperatDebugger.debug((String)"Value=%s", (Object[])new Object[]{value});
        if (!value.contains(RANGE_CHARACTER_WITHOUT_ESCAPE)) {
            N numericValue = this.numericField.parseNumber(value);
            return Range.atLeast(numericValue);
        }
        if (value.startsWith(RANGE_CHARACTER_WITHOUT_ESCAPE)) {
            N rangeValue = this.numericField.parseNumber(value.replace(RANGE_CHARACTER_WITHOUT_ESCAPE, ""));
            return Range.atLeast(rangeValue);
        }
        if (value.endsWith(RANGE_CHARACTER_WITHOUT_ESCAPE)) {
            N rangeValue = this.numericField.parseNumber(value.replace(RANGE_CHARACTER_WITHOUT_ESCAPE, ""));
            return Range.atMost(rangeValue);
        }
        String[] minMaxSplit = value.split(RANGE_CHARACTER);
        if (minMaxSplit.length > 2) {
            throw new SourceException("Invalid distance range format '%s'", new Object[]{value});
        }
        String minStr = minMaxSplit[0];
        String maxStr = minMaxSplit[1];
        ImperatDebugger.debug((String)("Min=" + minStr), (Object[])new Object[0]);
        ImperatDebugger.debug((String)("Max=" + maxStr), (Object[])new Object[0]);
        if (!TypeUtility.isNumber((String)minStr)) {
            throw new SourceException("Invalid min-value '%s'", new Object[]{minStr});
        }
        if (!TypeUtility.isNumber((String)maxStr)) {
            throw new SourceException("Invalid max-value '%s'", new Object[]{maxStr});
        }
        Object min = this.numericField.parseFieldValue(minStr);
        Object max = this.numericField.parseFieldValue(maxStr);
        return Range.of(min, max);
    }
}

