/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.selector;

import dev.velix.imperat.selector.SelectionType;
import java.util.Iterator;
import java.util.List;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

public final class TargetSelector
implements Iterable<Entity> {
    private final SelectionType type;
    private final List<Entity> selectedEntities;

    private TargetSelector(SelectionType type, List<Entity> selectedEntities) {
        this.type = type;
        this.selectedEntities = selectedEntities;
    }

    public static TargetSelector of(SelectionType type, List<Entity> list) {
        return new TargetSelector(type, list);
    }

    public static TargetSelector of(SelectionType type, Entity ... list) {
        return TargetSelector.of(type, List.of(list));
    }

    public static TargetSelector empty() {
        return TargetSelector.of(SelectionType.UNKNOWN, List.of());
    }

    @Override
    @NotNull
    public Iterator<Entity> iterator() {
        return this.selectedEntities.iterator();
    }

    public SelectionType getType() {
        return this.type;
    }

    public int size() {
        return this.selectedEntities.size();
    }
}

