/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.selector;

import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.SourceException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public interface SelectionType {
    public static final String MENTION_CHARACTER = "@";
    public static final SelectionType COMMAND_EXECUTOR = new SelectionType(){

        @Override
        public String id() {
            return "s";
        }

        @Override
        @NotNull
        public <E extends Entity> List<E> getTargetEntities(@NotNull ExecutionContext<BukkitSource> context, @NotNull CommandInputStream<BukkitSource> commandInputStream) throws ImperatException {
            if (((BukkitSource)context.source()).isConsole()) {
                throw new SourceException("Only players can do this !", new Object[0]);
            }
            return List.of(((BukkitSource)context.source()).asPlayer());
        }
    };
    public static final SelectionType CLOSEST_PLAYER = new SelectionType(){

        @Override
        public String id() {
            return "p";
        }

        @Override
        @NotNull
        public <E extends Entity> List<E> getTargetEntities(@NotNull ExecutionContext<BukkitSource> context, @NotNull CommandInputStream<BukkitSource> commandInputStream) throws ImperatException {
            if (((BukkitSource)context.source()).isConsole()) {
                throw new SourceException("Only players can do this !", new Object[0]);
            }
            Player sender = ((BukkitSource)context.source()).asPlayer();
            Location location = sender.getLocation();
            double MIN_DISTANCE = Double.MAX_VALUE;
            Player target = sender;
            for (Player other : Bukkit.getOnlinePlayers()) {
                double distance;
                if (other.getUniqueId().equals(sender.getUniqueId()) || !((distance = other.getLocation().distanceSquared(location)) < MIN_DISTANCE)) continue;
                MIN_DISTANCE = distance;
                sender = other;
            }
            return List.of(target);
        }
    };
    public static final SelectionType RANDOM_PLAYER = new SelectionType(){

        @Override
        public String id() {
            return "r";
        }

        @Override
        @NotNull
        public <E extends Entity> List<E> getTargetEntities(@NotNull ExecutionContext<BukkitSource> context, @NotNull CommandInputStream<BukkitSource> commandInputStream) throws ImperatException {
            ArrayList onlinePlayers = new ArrayList(Bukkit.getOnlinePlayers());
            return List.of((Entity)onlinePlayers.get(ThreadLocalRandom.current().nextInt(onlinePlayers.size())));
        }
    };
    public static final SelectionType ALL_PLAYERS = new SelectionType(){

        @Override
        public String id() {
            return "a";
        }

        @Override
        @NotNull
        public <E extends Entity> List<E> getTargetEntities(@NotNull ExecutionContext<BukkitSource> context, @NotNull CommandInputStream<BukkitSource> commandInputStream) throws ImperatException {
            return new ArrayList(Bukkit.getOnlinePlayers());
        }
    };
    public static final SelectionType ALL_ENTITIES = new SelectionType(){

        @Override
        public String id() {
            return "e";
        }

        @Override
        @NotNull
        public <E extends Entity> List<E> getTargetEntities(@NotNull ExecutionContext<BukkitSource> context, @NotNull CommandInputStream<BukkitSource> commandInputStream) throws ImperatException {
            if (((BukkitSource)context.source()).isConsole()) {
                throw new SourceException("Only players can do this !", new Object[0]);
            }
            Player player = ((BukkitSource)context.source()).asPlayer();
            World world = player.getWorld();
            return world.getEntities();
        }
    };
    public static final SelectionType UNKNOWN = new SelectionType(){

        @Override
        public String id() {
            return "unknown";
        }

        @Override
        @NotNull
        public <E extends Entity> List<E> getTargetEntities(@NotNull ExecutionContext<BukkitSource> context, @NotNull CommandInputStream<BukkitSource> commandInputStream) throws ImperatException {
            return List.of();
        }
    };
    public static final List<SelectionType> TYPES = List.of(COMMAND_EXECUTOR, CLOSEST_PLAYER, RANDOM_PLAYER, ALL_ENTITIES, ALL_PLAYERS);

    public String id();

    @NotNull
    public <E extends Entity> List<E> getTargetEntities(@NotNull ExecutionContext<BukkitSource> var1, @NotNull CommandInputStream<BukkitSource> var2) throws ImperatException;

    @NotNull
    public static SelectionType from(String id) {
        for (SelectionType type : TYPES) {
            if (!type.id().equalsIgnoreCase(id)) continue;
            return type;
        }
        return UNKNOWN;
    }
}

