/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.selector;

import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.selector.field.SelectionField;
import dev.velix.imperat.selector.field.provider.FieldProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SelectionParameterInput<V> {
    private final SelectionField<V> field;
    private final V value;

    private SelectionParameterInput(SelectionField<V> field, String input) throws ImperatException {
        this.field = field;
        this.value = field.parseFieldValue(input);
    }

    public static <V> SelectionParameterInput<V> from(SelectionField<V> field, String input) throws ImperatException {
        return new SelectionParameterInput<V>(field, input);
    }

    public SelectionField<V> getField() {
        return this.field;
    }

    public V getValue() {
        return this.value;
    }

    public static SelectionParameterInput<?> parse(String str, CommandInputStream<BukkitSource> commandInputStream) throws ImperatException {
        String[] split = str.split(String.valueOf('='));
        if (split.length != 2) {
            throw new SourceException("Invalid field-criteria format '%s'", new Object[]{str});
        }
        String field = split[0];
        String value = split[1];
        SelectionField selectionField = FieldProvider.INSTANCE.provideField(field, commandInputStream);
        if (selectionField == null) {
            throw new SourceException("Unknown field '%s'", new Object[]{field});
        }
        return new SelectionParameterInput(selectionField, value);
    }

    public static List<SelectionParameterInput<?>> parseAll(String paramsString, CommandInputStream<BukkitSource> inputStream) throws ImperatException {
        String[] params = paramsString.split(String.valueOf(','));
        if (params.length == 0) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        for (String str : params) {
            SelectionParameterInput<?> from = SelectionParameterInput.parse(str, inputStream);
            list.add(from);
        }
        return list;
    }
}

