/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.brigadier;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import dev.velix.imperat.ArgumentTypeResolver;
import dev.velix.imperat.brigadier.MinecraftArgumentType;
import dev.velix.imperat.command.parameters.NumericRange;
import dev.velix.imperat.command.parameters.type.ParameterWord;
import dev.velix.imperat.util.TypeUtility;
import java.lang.reflect.Type;
import org.jetbrains.annotations.Nullable;

class DefaultArgTypeResolvers {
    public static final ArgumentTypeResolver STRING = parameter -> {
        if (parameter.isGreedy()) {
            return StringArgumentType.greedyString();
        }
        if (parameter.type() instanceof ParameterWord) {
            return StringArgumentType.word();
        }
        return StringArgumentType.string();
    };
    public static final ArgumentTypeResolver BOOLEAN = parameter -> BoolArgumentType.bool();
    public static final ArgumentTypeResolver NUMERIC = parameter -> {
        if (parameter.isNumeric()) {
            NumericRange range = parameter.asNumeric().getRange();
            return DefaultArgTypeResolvers.numeric(parameter.valueType(), range);
        }
        return null;
    };
    private static final ArgumentType<?> SINGLE_PLAYER = DefaultArgTypeResolvers.entity(true, true);
    public static final ArgumentTypeResolver PLAYER = parameter -> SINGLE_PLAYER;
    private static final ArgumentType<?> MULTI_ENTITY = DefaultArgTypeResolvers.entity(false, false);
    public static final ArgumentTypeResolver ENTITY_SELECTOR = parameter -> MULTI_ENTITY;

    DefaultArgTypeResolvers() {
    }

    private static ArgumentType<? extends Number> numeric(Type type, @Nullable NumericRange range) {
        if (TypeUtility.matches((Type)type, Integer.TYPE)) {
            return IntegerArgumentType.integer((int)((int)DefaultArgTypeResolvers.getMin(range)), (int)((int)DefaultArgTypeResolvers.getMax(range)));
        }
        if (TypeUtility.matches((Type)type, Long.TYPE)) {
            return LongArgumentType.longArg((long)((long)DefaultArgTypeResolvers.getMin(range)), (long)((long)DefaultArgTypeResolvers.getMax(range)));
        }
        if (TypeUtility.matches((Type)type, Float.TYPE)) {
            return FloatArgumentType.floatArg((float)((float)DefaultArgTypeResolvers.getMin(range)), (float)((float)DefaultArgTypeResolvers.getMax(range)));
        }
        if (TypeUtility.matches((Type)type, Double.TYPE)) {
            return DoubleArgumentType.doubleArg((double)DefaultArgTypeResolvers.getMin(range), (double)DefaultArgTypeResolvers.getMax(range));
        }
        throw new IllegalArgumentException("Unsupported numeric valueType: " + String.valueOf(type));
    }

    private static double getMin(@Nullable NumericRange range) {
        if (range == null) {
            return Double.MIN_VALUE;
        }
        return range.getMin();
    }

    private static double getMax(@Nullable NumericRange range) {
        if (range == null) {
            return Double.MAX_VALUE;
        }
        return range.getMax();
    }

    private static ArgumentType<?> entity(boolean single, boolean playerOnly) {
        return MinecraftArgumentType.ENTITY.create(single, playerOnly);
    }
}

