/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat;

import dev.velix.imperat.adventure.AdventureProvider;
import dev.velix.imperat.context.Source;
import net.kyori.adventure.text.ComponentLike;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitSource
implements Source {
    protected final CommandSender sender;
    protected final AdventureProvider<CommandSender> provider;

    protected BukkitSource(CommandSender sender, AdventureProvider<CommandSender> provider) {
        this.sender = sender;
        this.provider = provider;
    }

    public AdventureProvider<CommandSender> getProvider() {
        return this.provider;
    }

    public String name() {
        return this.sender.getName();
    }

    public CommandSender origin() {
        return this.sender;
    }

    public Player asPlayer() {
        return this.as(Player.class);
    }

    public void reply(String message) {
        this.sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    public void warn(String message) {
        this.reply(String.valueOf(ChatColor.YELLOW) + message);
    }

    public void error(String message) {
        this.reply(String.valueOf(ChatColor.RED) + message);
    }

    public void reply(ComponentLike component) {
        this.provider.send((Source)this, component);
    }

    public boolean isConsole() {
        return !(this.sender instanceof Player);
    }

    public <T> T as(Class<T> clazz) {
        return (T)this.origin();
    }
}

