/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat;

import dev.velix.imperat.BukkitAdventure;
import dev.velix.imperat.BukkitImperat;
import dev.velix.imperat.BukkitPermissionResolver;
import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.ConfigBuilder;
import dev.velix.imperat.ImperatConfig;
import dev.velix.imperat.adventure.AdventureProvider;
import dev.velix.imperat.adventure.CastingAdventure;
import dev.velix.imperat.adventure.EmptyAdventure;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.exception.UnknownOfflinePlayerException;
import dev.velix.imperat.exception.UnknownPlayerException;
import dev.velix.imperat.exception.UnknownWorldException;
import dev.velix.imperat.resolvers.PermissionResolver;
import dev.velix.imperat.selector.TargetSelector;
import dev.velix.imperat.type.ParameterLocation;
import dev.velix.imperat.type.ParameterOfflinePlayer;
import dev.velix.imperat.type.ParameterPlayer;
import dev.velix.imperat.type.ParameterTargetSelector;
import dev.velix.imperat.util.reflection.Reflections;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class BukkitConfigBuilder
extends ConfigBuilder<BukkitSource, BukkitImperat> {
    private static final BukkitPermissionResolver DEFAULT_PERMISSION_RESOLVER = new BukkitPermissionResolver();
    private final Plugin plugin;
    private AdventureProvider<CommandSender> adventureProvider;
    private boolean supportBrigadier = false;

    BukkitConfigBuilder(Plugin plugin) {
        this.plugin = plugin;
        this.config.setPermissionResolver((PermissionResolver)DEFAULT_PERMISSION_RESOLVER);
        this.addThrowableHandlers();
        this.registerSourceResolvers();
        this.registerValueResolvers();
    }

    private void registerSourceResolvers() {
        this.config.registerSourceResolver(CommandSender.class, BukkitSource::origin);
        this.config.registerSourceResolver(Player.class, source -> {
            if (source.isConsole()) {
                throw new SourceException("Only players are allowed to do this !", new Object[0]);
            }
            return source.asPlayer();
        });
    }

    private void addThrowableHandlers() {
        this.config.setThrowableResolver(UnknownPlayerException.class, (exception, imperat, context) -> ((BukkitSource)context.source()).error("A player with the name '" + exception.getName() + "' doesn't seem to be online"));
        this.config.setThrowableResolver(UnknownOfflinePlayerException.class, (exception, imperat, context) -> ((BukkitSource)context.source()).error("A player with the name '" + exception.getName() + "' doesn't seem to exist"));
        this.config.setThrowableResolver(UnknownWorldException.class, (exception, imperat, context) -> ((BukkitSource)context.source()).error("A world with the name '" + exception.getName() + "' doesn't seem to exist"));
    }

    private void registerValueResolvers() {
        this.config.registerParamType(Player.class, (ParameterType)new ParameterPlayer());
        this.config.registerParamType(OfflinePlayer.class, (ParameterType)new ParameterOfflinePlayer());
        this.config.registerParamType(Location.class, (ParameterType)new ParameterLocation());
        this.config.registerParamType(TargetSelector.class, (ParameterType)new ParameterTargetSelector());
    }

    public void setAdventureProvider(AdventureProvider<CommandSender> adventureProvider) {
        this.adventureProvider = adventureProvider;
    }

    public BukkitConfigBuilder applyBrigadier(boolean supportBrigadier) {
        this.supportBrigadier = supportBrigadier;
        return this;
    }

    @NotNull
    public BukkitImperat build() {
        if (this.adventureProvider == null) {
            this.adventureProvider = this.loadAdventure();
        }
        return new BukkitImperat(this.plugin, this.adventureProvider, this.supportBrigadier, (ImperatConfig<BukkitSource>)this.config);
    }

    @NotNull
    private AdventureProvider<CommandSender> loadAdventure() {
        if (Reflections.findClass((String[])new String[]{"net.kyori.adventure.audience.Audience"})) {
            if (Audience.class.isAssignableFrom(CommandSender.class)) {
                return new CastingAdventure();
            }
            if (Reflections.findClass((String[])new String[]{"net.kyori.adventure.platform.bukkit.BukkitAudiences"})) {
                return new BukkitAdventure(this.plugin);
            }
        }
        return new EmptyAdventure();
    }
}

