/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.adventure;

import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.help.HelpProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class TreeHelpProvider<S extends Source>
implements HelpProvider<S> {
    private final Theme config;
    private final ResponseHandler<S> responseHandler;
    private Function<String, String> footerCommandFormatter = cmd -> cmd;

    public TreeHelpProvider(ResponseHandler<S> responseHandler) {
        this.config = new Theme();
        this.responseHandler = responseHandler;
    }

    public TreeHelpProvider(Theme config, ResponseHandler<S> responseHandler) {
        this.config = config;
        this.responseHandler = responseHandler;
    }

    public TreeHelpProvider<S> setFooterCommandFormatter(Function<String, String> formatter) {
        this.footerCommandFormatter = formatter;
        return this;
    }

    public void provide(ExecutionContext<S> context, S source) throws ImperatException {
        String mainUsage;
        Command command = context.command();
        TextComponent.Builder headerBuilder = Component.text();
        headerBuilder.append(this.config.getPrefix());
        TextComponent nameComponent = Component.text((String)command.name(), (TextColor)this.config.getCommandNameColor());
        for (TextDecoration decoration : this.config.getCommandNameDecorations()) {
            nameComponent = nameComponent.decoration(decoration, true);
        }
        headerBuilder.append((Component)nameComponent);
        if (this.config.isShowUsage() && !(mainUsage = CommandUsage.format((String)null, (CommandUsage)command.mainUsage())).isEmpty()) {
            Object usageComponent = Component.text((String)(this.config.getUsagePrefix() + mainUsage), (TextColor)this.config.getUsageColor());
            for (TextDecoration decoration : this.config.getUsageDecorations()) {
                usageComponent = usageComponent.decoration(decoration, true);
            }
            headerBuilder.append((Component)usageComponent);
        }
        if (this.config.isShowDescriptions() && !command.description().isEmpty()) {
            Component descComponent = Component.text((String)this.config.getSeparator(), (TextColor)this.config.getSeparatorColor()).append((Component)Component.text((String)command.description().toString(), (TextColor)this.config.getDescriptionColor()));
            for (TextDecoration decoration : this.config.getDescriptionDecorations()) {
                descComponent = descComponent.decoration(decoration, true);
            }
            headerBuilder.append(descComponent);
        }
        this.responseHandler.reply(source, (Component)headerBuilder.build());
        ArrayList subCommands = new ArrayList(command.getSubCommands());
        if (subCommands.isEmpty()) {
            String mainUsage2 = CommandUsage.format((String)null, (CommandUsage)command.mainUsage());
            if (mainUsage2.isEmpty() || !this.config.isShowUsage()) {
                this.responseHandler.reply(source, (Component)Component.text((String)this.config.getNoCommandsMessage(), (TextColor)this.config.getHeaderColor()));
            }
        } else {
            if (this.config.isShowHeader()) {
                this.responseHandler.reply(source, (Component)Component.text((String)this.config.getHeaderMessage(), (TextColor)this.config.getHeaderColor()).decorate(this.config.getHeaderDecorations()));
            }
            for (int i = 0; i < subCommands.size(); ++i) {
                boolean isLast = i == subCommands.size() - 1;
                this.displaySubCommand(source, (Command)subCommands.get(i), isLast, new ArrayList<Boolean>(), 0);
            }
            if (this.config.isShowFooter()) {
                String footerText = this.config.getFooterMessage().replace("{command}", this.footerCommandFormatter.apply(command.name()));
                this.responseHandler.reply(source, (Component)Component.text((String)footerText, (TextColor)this.config.getFooterColor()).decorate(this.config.getFooterDecorations()));
            }
        }
    }

    private void displaySubCommand(S source, Command<S> command, boolean isLast, List<Boolean> indentationPattern, int depth) {
        if (this.config.getMaxDepth() > 0 && depth >= this.config.getMaxDepth()) {
            return;
        }
        Component prefix = this.buildPrefix(indentationPattern, isLast);
        TextComponent nameComponent = Component.text((String)command.name(), (TextColor)this.config.getSubCommandNameColor());
        for (TextDecoration decoration : this.config.getSubCommandNameDecorations()) {
            nameComponent = nameComponent.decoration(decoration, true);
        }
        TextComponent usageComponent = Component.empty();
        ArrayList children = new ArrayList(command.getSubCommands());
        if (this.config.isShowUsage()) {
            usageComponent = this.formatUsage(command.mainUsage());
        }
        TextComponent descriptionComponent = Component.empty();
        if (this.config.isShowDescriptions() && !command.description().isEmpty()) {
            descriptionComponent = Component.text((String)this.config.getSeparator(), (TextColor)this.config.getSeparatorColor()).append((Component)Component.text((String)command.description().toString(), (TextColor)this.config.getDescriptionColor()));
            for (TextDecoration decoration : this.config.getDescriptionDecorations()) {
                descriptionComponent = descriptionComponent.decoration(decoration, true);
            }
        }
        if (this.config.isShowSubCommandCount() && !children.isEmpty()) {
            String countText = " [" + children.size() + "]";
            descriptionComponent = descriptionComponent.append((Component)Component.text((String)countText, (TextColor)this.config.getSeparatorColor()));
        }
        this.responseHandler.reply(source, ((TextComponent)((TextComponent)((TextComponent)Component.empty().append(prefix)).append((Component)nameComponent)).append((Component)usageComponent)).append((Component)descriptionComponent));
        if (!children.isEmpty()) {
            ArrayList<Boolean> newPattern = new ArrayList<Boolean>(indentationPattern);
            newPattern.add(!isLast);
            for (int i = 0; i < children.size(); ++i) {
                boolean isLastChild = i == children.size() - 1;
                this.displaySubCommand(source, (Command)children.get(i), isLastChild, newPattern, depth + 1);
            }
        }
    }

    private Component buildPrefix(List<Boolean> indentationPattern, boolean isLast) {
        TextComponent prefix = Component.empty();
        if (this.config.isCompactView()) {
            for (int i = 0; i < indentationPattern.size(); ++i) {
                prefix = prefix.append(this.config.getEmptyIndent());
            }
        } else {
            for (Boolean shouldIndent : indentationPattern) {
                prefix = prefix.append(shouldIndent != false ? this.config.getIndent() : this.config.getEmptyIndent());
            }
        }
        prefix = prefix.append(isLast ? this.config.getLastBranch() : this.config.getBranch());
        return prefix;
    }

    private Component formatUsage(CommandUsage<S> commandUsage) {
        if (commandUsage == null || commandUsage.size() == 0) {
            return Component.empty();
        }
        String usage = CommandUsage.format((String)null, commandUsage);
        TextComponent usageComponent = Component.text((String)(this.config.getUsagePrefix() + usage), (TextColor)this.config.getUsageColor());
        for (TextDecoration decoration : this.config.getUsageDecorations()) {
            usageComponent = usageComponent.decoration(decoration, true);
        }
        return usageComponent;
    }

    public Theme getConfig() {
        return this.config;
    }

    public static class Theme {
        private Component prefix = Component.text((String)"/", (TextColor)NamedTextColor.GRAY);
        private Component branch = Component.text((String)"\u251c\u2500 ", (TextColor)NamedTextColor.DARK_GRAY);
        private Component lastBranch = Component.text((String)"\u2514\u2500 ", (TextColor)NamedTextColor.DARK_GRAY);
        private Component indent = Component.text((String)"\u2502  ", (TextColor)NamedTextColor.DARK_GRAY);
        private Component emptyIndent = Component.text((String)"   ", (TextColor)NamedTextColor.DARK_GRAY);
        private TextColor commandNameColor = NamedTextColor.GOLD;
        private TextColor subCommandNameColor = NamedTextColor.YELLOW;
        private TextColor usageColor = NamedTextColor.AQUA;
        private TextColor descriptionColor = NamedTextColor.WHITE;
        private TextColor separatorColor = NamedTextColor.GRAY;
        private TextColor headerColor = NamedTextColor.GRAY;
        private TextColor footerColor = NamedTextColor.GRAY;
        private List<TextDecoration> commandNameDecorations = new ArrayList<TextDecoration>();
        private List<TextDecoration> subCommandNameDecorations = new ArrayList<TextDecoration>();
        private List<TextDecoration> usageDecorations = new ArrayList<TextDecoration>();
        private List<TextDecoration> descriptionDecorations = new ArrayList<TextDecoration>();
        private TextDecoration[] headerDecorations = new TextDecoration[0];
        private TextDecoration[] footerDecorations = new TextDecoration[0];
        private String separator = " - ";
        private String usagePrefix = " ";
        private boolean showDescriptions = true;
        private boolean showUsage = true;
        private boolean showSubCommandCount = false;
        private boolean showFooter = true;
        private boolean showHeader = true;
        private String headerMessage = "Available subcommands:";
        private String noCommandsMessage = "This command has no additional parameters.";
        private String footerMessage = "Contact an admin for more information";
        private int maxDepth = -1;
        private boolean compactView = false;

        public Theme setPrefix(Component prefix) {
            this.prefix = prefix;
            return this;
        }

        public Theme setPrefix(String prefix, TextColor color) {
            this.prefix = Component.text((String)prefix, (TextColor)color);
            return this;
        }

        public Theme setBranch(Component branch) {
            this.branch = branch;
            return this;
        }

        public Theme setBranch(String branch, TextColor color) {
            this.branch = Component.text((String)branch, (TextColor)color);
            return this;
        }

        public Theme setLastBranch(Component lastBranch) {
            this.lastBranch = lastBranch;
            return this;
        }

        public Theme setLastBranch(String lastBranch, TextColor color) {
            this.lastBranch = Component.text((String)lastBranch, (TextColor)color);
            return this;
        }

        public Theme setIndent(Component indent) {
            this.indent = indent;
            return this;
        }

        public Theme setIndent(String indent, TextColor color) {
            this.indent = Component.text((String)indent, (TextColor)color);
            return this;
        }

        public Theme setEmptyIndent(Component emptyIndent) {
            this.emptyIndent = emptyIndent;
            return this;
        }

        public Theme setEmptyIndent(String emptyIndent, TextColor color) {
            this.emptyIndent = Component.text((String)emptyIndent, (TextColor)color);
            return this;
        }

        public Theme setCommandNameColor(TextColor commandNameColor) {
            this.commandNameColor = commandNameColor;
            return this;
        }

        public Theme setCommandNameColor(String hexColor) {
            this.commandNameColor = TextColor.fromHexString((String)hexColor);
            return this;
        }

        public Theme setSubCommandNameColor(TextColor subCommandNameColor) {
            this.subCommandNameColor = subCommandNameColor;
            return this;
        }

        public Theme setSubCommandNameColor(String hexColor) {
            this.subCommandNameColor = TextColor.fromHexString((String)hexColor);
            return this;
        }

        public Theme setUsageColor(TextColor usageColor) {
            this.usageColor = usageColor;
            return this;
        }

        public Theme setUsageColor(String hexColor) {
            this.usageColor = TextColor.fromHexString((String)hexColor);
            return this;
        }

        public Theme setDescriptionColor(TextColor descriptionColor) {
            this.descriptionColor = descriptionColor;
            return this;
        }

        public Theme setDescriptionColor(String hexColor) {
            this.descriptionColor = TextColor.fromHexString((String)hexColor);
            return this;
        }

        public Theme setSeparatorColor(TextColor separatorColor) {
            this.separatorColor = separatorColor;
            return this;
        }

        public Theme setSeparatorColor(String hexColor) {
            this.separatorColor = TextColor.fromHexString((String)hexColor);
            return this;
        }

        public Theme setHeaderColor(TextColor headerColor) {
            this.headerColor = headerColor;
            return this;
        }

        public Theme setHeaderColor(String hexColor) {
            this.headerColor = TextColor.fromHexString((String)hexColor);
            return this;
        }

        public Theme setFooterColor(TextColor footerColor) {
            this.footerColor = footerColor;
            return this;
        }

        public Theme setFooterColor(String hexColor) {
            this.footerColor = TextColor.fromHexString((String)hexColor);
            return this;
        }

        public Theme setHeaderDecorations(TextDecoration ... decorations) {
            this.headerDecorations = decorations;
            return this;
        }

        public Theme setFooterDecorations(TextDecoration ... decorations) {
            this.footerDecorations = decorations;
            return this;
        }

        public Theme setCommandNameDecorations(List<TextDecoration> commandNameDecorations) {
            this.commandNameDecorations = commandNameDecorations;
            return this;
        }

        public Theme setCommandNameDecorations(TextDecoration ... decorations) {
            this.commandNameDecorations = Arrays.asList(decorations);
            return this;
        }

        public Theme setSubCommandNameDecorations(List<TextDecoration> subCommandNameDecorations) {
            this.subCommandNameDecorations = subCommandNameDecorations;
            return this;
        }

        public Theme setSubCommandNameDecorations(TextDecoration ... decorations) {
            this.subCommandNameDecorations = Arrays.asList(decorations);
            return this;
        }

        public Theme setUsageDecorations(List<TextDecoration> usageDecorations) {
            this.usageDecorations = usageDecorations;
            return this;
        }

        public Theme setUsageDecorations(TextDecoration ... decorations) {
            this.usageDecorations = Arrays.asList(decorations);
            return this;
        }

        public Theme setDescriptionDecorations(List<TextDecoration> descriptionDecorations) {
            this.descriptionDecorations = descriptionDecorations;
            return this;
        }

        public Theme setDescriptionDecorations(TextDecoration ... decorations) {
            this.descriptionDecorations = Arrays.asList(decorations);
            return this;
        }

        public Theme setSeparator(String separator) {
            this.separator = separator;
            return this;
        }

        public Theme setUsagePrefix(String usagePrefix) {
            this.usagePrefix = usagePrefix;
            return this;
        }

        public Theme setShowDescriptions(boolean showDescriptions) {
            this.showDescriptions = showDescriptions;
            return this;
        }

        public Theme setShowUsage(boolean showUsage) {
            this.showUsage = showUsage;
            return this;
        }

        public Theme setShowSubCommandCount(boolean showSubCommandCount) {
            this.showSubCommandCount = showSubCommandCount;
            return this;
        }

        public Theme setShowFooter(boolean showFooter) {
            this.showFooter = showFooter;
            return this;
        }

        public Theme setShowHeader(boolean showHeader) {
            this.showHeader = showHeader;
            return this;
        }

        public Theme setHeaderMessage(String headerMessage) {
            this.headerMessage = headerMessage;
            return this;
        }

        public Theme setNoCommandsMessage(String noCommandsMessage) {
            this.noCommandsMessage = noCommandsMessage;
            return this;
        }

        public Theme setFooterMessage(String footerMessage) {
            this.footerMessage = footerMessage;
            return this;
        }

        public Theme setMaxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public Theme setCompactView(boolean compactView) {
            this.compactView = compactView;
            return this;
        }

        public static Theme createDefaultTheme() {
            return new Theme();
        }

        public static Theme createMinimalTheme() {
            return new Theme().setBranch("+ ", (TextColor)NamedTextColor.GRAY).setLastBranch("+ ", (TextColor)NamedTextColor.GRAY).setIndent("  ", (TextColor)NamedTextColor.GRAY).setEmptyIndent("  ", (TextColor)NamedTextColor.GRAY).setCompactView(true);
        }

        public static Theme createModernTheme() {
            return new Theme().setBranch("\u251c\u2500 ", TextColor.fromHexString((String)"#4A90E2")).setLastBranch("\u2514\u2500 ", TextColor.fromHexString((String)"#4A90E2")).setIndent("\u2502   ", TextColor.fromHexString((String)"#4A90E2")).setEmptyIndent("    ", TextColor.fromHexString((String)"#4A90E2")).setCommandNameColor(TextColor.fromHexString((String)"#50C878")).setSubCommandNameColor(TextColor.fromHexString((String)"#00BFFF")).setDescriptionColor(TextColor.fromHexString((String)"#F5F5F5")).setUsageColor(TextColor.fromHexString((String)"#FFD700")).setSeparatorColor(TextColor.fromHexString((String)"#A9A9A9")).setHeaderColor(TextColor.fromHexString((String)"#B0C4DE")).setFooterColor(TextColor.fromHexString((String)"#B0C4DE")).setCommandNameDecorations(TextDecoration.BOLD);
        }

        public static Theme createDarkTheme() {
            return new Theme().setBranch("\u251c\u2500 ", TextColor.fromHexString((String)"#555555")).setLastBranch("\u2514\u2500 ", TextColor.fromHexString((String)"#555555")).setIndent("\u2502  ", TextColor.fromHexString((String)"#555555")).setEmptyIndent("   ", TextColor.fromHexString((String)"#555555")).setCommandNameColor(TextColor.fromHexString((String)"#FF7F50")).setSubCommandNameColor(TextColor.fromHexString((String)"#FF6347")).setDescriptionColor(TextColor.fromHexString((String)"#CCCCCC")).setUsageColor(TextColor.fromHexString((String)"#87CEFA")).setSeparatorColor(TextColor.fromHexString((String)"#777777")).setHeaderColor(TextColor.fromHexString((String)"#AAAAAA")).setFooterColor(TextColor.fromHexString((String)"#AAAAAA"));
        }

        public static Theme createVibrantTheme() {
            return new Theme().setBranch("\u25ba\u2500 ", TextColor.fromHexString((String)"#FF00FF")).setLastBranch("\u25bc\u2500 ", TextColor.fromHexString((String)"#FF00FF")).setIndent("\u2502  ", TextColor.fromHexString((String)"#9370DB")).setEmptyIndent("   ", TextColor.fromHexString((String)"#9370DB")).setCommandNameColor(TextColor.fromHexString((String)"#9251c8")).setSubCommandNameColor(TextColor.fromHexString((String)"#cbcd37")).setDescriptionColor(TextColor.fromHexString((String)"#F0F8FF")).setUsageColor(TextColor.fromHexString((String)"#00FFFF")).setSeparatorColor(TextColor.fromHexString((String)"#DA70D6")).setHeaderColor(TextColor.fromHexString((String)"#EE82EE")).setFooterColor(TextColor.fromHexString((String)"#EE82EE"));
        }

        public static Theme createRpgTheme() {
            return new Theme().setBranch("\u251c\u2500 ", TextColor.fromHexString((String)"#CD853F")).setLastBranch("\u2514\u2500 ", TextColor.fromHexString((String)"#CD853F")).setIndent("\u2502  ", TextColor.fromHexString((String)"#8B4513")).setEmptyIndent("   ", TextColor.fromHexString((String)"#8B4513")).setCommandNameColor(TextColor.fromHexString((String)"#FFD700")).setSubCommandNameColor(TextColor.fromHexString((String)"#DAA520")).setDescriptionColor(TextColor.fromHexString((String)"#F5DEB3")).setUsageColor(TextColor.fromHexString((String)"#AFEEEE")).setSeparatorColor(TextColor.fromHexString((String)"#A0522D")).setHeaderColor(TextColor.fromHexString((String)"#D2B48C")).setFooterColor(TextColor.fromHexString((String)"#D2B48C")).setHeaderMessage("\u269c Available magical commands:").setFooterMessage("Use /{command} help for ancient knowledge");
        }

        public static Theme createCyberpunkTheme() {
            return new Theme().setBranch("\u300b ", TextColor.fromHexString((String)"#FF00FF")).setLastBranch("\u300b ", TextColor.fromHexString((String)"#FF00FF")).setIndent("\u2503 ", TextColor.fromHexString((String)"#00FFFF")).setEmptyIndent("  ", TextColor.fromHexString((String)"#00FFFF")).setCommandNameColor(TextColor.fromHexString((String)"#FF355E")).setSubCommandNameColor(TextColor.fromHexString((String)"#00FF00")).setDescriptionColor(TextColor.fromHexString((String)"#FFFFFF")).setUsageColor(TextColor.fromHexString((String)"#FFFF00")).setSeparatorColor(TextColor.fromHexString((String)"#FF69B4")).setHeaderColor(TextColor.fromHexString((String)"#00FFFF")).setFooterColor(TextColor.fromHexString((String)"#00FFFF")).setHeaderMessage("[SYSTEM] Available subroutines:").setFooterMessage("[SYSTEM] This is the documentation for /{command}").setSeparator(" :: ");
        }

        public static Theme createProfessionalTheme() {
            return new Theme().setBranch("\u251c\u2500\u2500 ", TextColor.fromHexString((String)"#B0B0B0")).setLastBranch("\u2514\u2500\u2500 ", TextColor.fromHexString((String)"#B0B0B0")).setIndent("\u2502   ", TextColor.fromHexString((String)"#B0B0B0")).setEmptyIndent("    ", TextColor.fromHexString((String)"#B0B0B0")).setCommandNameColor(TextColor.fromHexString((String)"#4169E1")).setSubCommandNameColor(TextColor.fromHexString((String)"#4169E1")).setDescriptionColor(TextColor.fromHexString((String)"#5F9EA0")).setUsageColor(TextColor.fromHexString((String)"#50C878")).setSeparatorColor(TextColor.fromHexString((String)"#808080")).setHeaderColor(TextColor.fromHexString((String)"#FFD700")).setFooterColor(TextColor.fromHexString((String)"#C0C0C0")).setCommandNameDecorations(TextDecoration.BOLD);
        }

        public static Theme createNeonTheme() {
            return new Theme().setBranch("\u2560\u2550 ", TextColor.fromHexString((String)"#FF00FF")).setLastBranch("\u255a\u2550 ", TextColor.fromHexString((String)"#FF00FF")).setIndent("\u2551  ", TextColor.fromHexString((String)"#FF00FF")).setEmptyIndent("   ", TextColor.fromHexString((String)"#FF00FF")).setCommandNameColor(TextColor.fromHexString((String)"#00FFFF")).setSubCommandNameColor(TextColor.fromHexString((String)"#00FF00")).setDescriptionColor(TextColor.fromHexString((String)"#FFFFFF")).setUsageColor(TextColor.fromHexString((String)"#FFFF00")).setSeparatorColor(TextColor.fromHexString((String)"#FF69B4")).setHeaderColor(TextColor.fromHexString((String)"#1e78ff")).setFooterColor(TextColor.fromHexString((String)"#1e78ff")).setHeaderMessage("\u00ab AVAILABLE COMMANDS \u00bb").setFooterMessage("Type /{command} help for more information");
        }

        public static Theme createSynthwaveTheme() {
            return new Theme().setBranch("\u25b8 ", TextColor.fromHexString((String)"#F92AFF")).setLastBranch("\u25b9 ", TextColor.fromHexString((String)"#F92AFF")).setIndent("\u2502 ", TextColor.fromHexString((String)"#A64DFF")).setEmptyIndent("  ", TextColor.fromHexString((String)"#A64DFF")).setCommandNameColor(TextColor.fromHexString((String)"#347338")).setSubCommandNameColor(TextColor.fromHexString((String)"#72F1B8")).setDescriptionColor(TextColor.fromHexString((String)"#F0F0F0")).setUsageColor(TextColor.fromHexString((String)"#FFF568")).setSeparatorColor(TextColor.fromHexString((String)"#F26DF9")).setHeaderColor(TextColor.fromHexString((String)"#FF8B8B")).setFooterColor(TextColor.fromHexString((String)"#FF8B8B")).setHeaderMessage("\u2593\u2592\u2591 COMMAND LIST \u2591\u2592\u2593").setFooterMessage("\u2593\u2592\u2591 Use /{command} for details \u2591\u2592\u2593").setSeparator(" \u2192 ");
        }

        public Component getPrefix() {
            return this.prefix;
        }

        public Component getBranch() {
            return this.branch;
        }

        public Component getLastBranch() {
            return this.lastBranch;
        }

        public Component getIndent() {
            return this.indent;
        }

        public Component getEmptyIndent() {
            return this.emptyIndent;
        }

        public TextColor getCommandNameColor() {
            return this.commandNameColor;
        }

        public TextColor getSubCommandNameColor() {
            return this.subCommandNameColor;
        }

        public TextColor getUsageColor() {
            return this.usageColor;
        }

        public TextColor getDescriptionColor() {
            return this.descriptionColor;
        }

        public TextColor getSeparatorColor() {
            return this.separatorColor;
        }

        public TextColor getHeaderColor() {
            return this.headerColor;
        }

        public TextColor getFooterColor() {
            return this.footerColor;
        }

        public List<TextDecoration> getCommandNameDecorations() {
            return this.commandNameDecorations;
        }

        public List<TextDecoration> getSubCommandNameDecorations() {
            return this.subCommandNameDecorations;
        }

        public List<TextDecoration> getUsageDecorations() {
            return this.usageDecorations;
        }

        public List<TextDecoration> getDescriptionDecorations() {
            return this.descriptionDecorations;
        }

        public TextDecoration[] getHeaderDecorations() {
            return this.headerDecorations;
        }

        public TextDecoration[] getFooterDecorations() {
            return this.footerDecorations;
        }

        public String getSeparator() {
            return this.separator;
        }

        public String getUsagePrefix() {
            return this.usagePrefix;
        }

        public boolean isShowDescriptions() {
            return this.showDescriptions;
        }

        public boolean isShowUsage() {
            return this.showUsage;
        }

        public boolean isShowSubCommandCount() {
            return this.showSubCommandCount;
        }

        public boolean isShowFooter() {
            return this.showFooter;
        }

        public boolean isShowHeader() {
            return this.showHeader;
        }

        public String getHeaderMessage() {
            return this.headerMessage;
        }

        public String getNoCommandsMessage() {
            return this.noCommandsMessage;
        }

        public String getFooterMessage() {
            return this.footerMessage;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public boolean isCompactView() {
            return this.compactView;
        }
    }

    @FunctionalInterface
    public static interface ResponseHandler<S extends Source> {
        public void reply(S var1, Component var2);
    }
}

