/*
 * Decompiled with CFR 0.152.
 */
package dev.sefiraat.sefilib.string;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.inventory.ItemStack;

public class Theme {
    public static final Theme WARNING = new Theme(ChatColor.YELLOW, "Warning");
    public static final Theme ERROR = new Theme(ChatColor.RED, "Error");
    public static final Theme NOTICE = new Theme(ChatColor.WHITE, "Notice");
    public static final Theme PASSIVE = new Theme(ChatColor.GRAY);
    public static final Theme SUCCESS = new Theme(ChatColor.GREEN, "Success");
    public static final Theme CLICK_INFO = new Theme(ChatColor.of((String)"#e4ed32"), "Click here");
    @Nonnull
    private final ChatColor color;
    @Nonnull
    private final String loreLine;

    public Theme(@Nonnull ChatColor color) {
        this(color, "");
    }

    public Theme(@Nonnull ChatColor color, @Nonnull String loreLine) {
        this.color = color;
        this.loreLine = loreLine;
    }

    public String color(@Nonnull String string) {
        return this + string;
    }

    @Nonnull
    public String apply(@Nonnull Object value) {
        return this.color + String.valueOf(value);
    }

    @Nonnull
    public String asTitle(@Nonnull Object value1, @Nonnull Object value2) {
        return this.color + String.valueOf(value1) + ": " + PASSIVE + value2;
    }

    @Nonnull
    public ChatColor getColor() {
        return this.color;
    }

    @Nonnull
    public Particle.DustOptions getDustOptions(float size) {
        return new Particle.DustOptions(Color.fromRGB((int)this.color.getColor().getRed(), (int)this.color.getColor().getGreen(), (int)this.color.getColor().getBlue()), size);
    }

    @Nonnull
    public String toString() {
        return this.color.toString();
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static SlimefunItemStack themedSlimefunItemStack(String id, ItemStack itemStack, Theme themeType, String name, String ... lore) {
        return Theme.themedSlimefunItemStack(id, itemStack, themeType, name, Arrays.asList(lore));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static SlimefunItemStack themedSlimefunItemStack(String id, ItemStack itemStack, Theme themeType, String name, List<String> lore) {
        ChatColor passiveColor = PASSIVE.getColor();
        ArrayList<Object> finalLore = new ArrayList<Object>();
        finalLore.add("");
        for (String s : lore) {
            finalLore.add(passiveColor + s);
        }
        finalLore.add("");
        finalLore.add(Theme.applyThemeToString(CLICK_INFO, themeType.getLoreLine()));
        return new SlimefunItemStack(id, itemStack, Theme.applyThemeToString(themeType, name), finalLore.toArray(new String[finalLore.size() - 1]));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static SlimefunItemStack themedSlimefunItemStack(String id, Material material, Theme themeType, String name, String ... lore) {
        return Theme.themedSlimefunItemStack(id, material, themeType, name, Arrays.asList(lore));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static SlimefunItemStack themedSlimefunItemStack(String id, Material material, Theme themeType, String name, List<String> lore) {
        ChatColor passiveColor = PASSIVE.getColor();
        ArrayList<Object> finalLore = new ArrayList<Object>();
        finalLore.add("");
        for (String s : lore) {
            finalLore.add(passiveColor + s);
        }
        finalLore.add("");
        finalLore.add(Theme.applyThemeToString(CLICK_INFO, themeType.getLoreLine()));
        return new SlimefunItemStack(id, material, Theme.applyThemeToString(themeType, name), finalLore.toArray(new String[finalLore.size() - 1]));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static SlimefunItemStack themedSeed(String id, ItemStack seedStack, Theme themeType, String name, String[] lore, String[] validPlacements) {
        return Theme.themedSeed(id, seedStack, themeType, name, Arrays.asList(lore), Arrays.asList(validPlacements));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static SlimefunItemStack themedSeed(String id, ItemStack seedStack, Theme themeType, String name, List<String> lore, List<String> validPlacements) {
        ChatColor passiveColor = PASSIVE.getColor();
        ArrayList<Object> finalLore = new ArrayList<Object>();
        finalLore.add("");
        for (String s : lore) {
            finalLore.add(passiveColor + s);
        }
        for (String s : validPlacements) {
            finalLore.add(passiveColor + s);
        }
        finalLore.add("");
        finalLore.add(Theme.applyThemeToString(CLICK_INFO, themeType.getLoreLine()));
        return new SlimefunItemStack(id, seedStack, Theme.applyThemeToString(themeType, name), finalLore.toArray(new String[finalLore.size() - 1]));
    }

    @Nonnull
    public static String applyThemeToString(@Nonnull Theme themeType, @Nonnull Object value) {
        return themeType.getColor() + String.valueOf(value);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static String applyThemeAsTitle(Theme themeType, String string1, Object value) {
        return themeType.getColor() + string1 + ": " + PASSIVE + value;
    }

    @Nonnull
    public String getLoreLine() {
        return this.loreLine;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static ItemStack themedItemStack(Material material, Theme themeType, String name, @Nullable List<String> lore) {
        ChatColor passiveColor = PASSIVE.getColor();
        ArrayList<Object> finalLore = new ArrayList<Object>();
        if (lore != null) {
            finalLore.add("");
            for (String s : lore) {
                finalLore.add(passiveColor + s);
            }
        }
        finalLore.add(Theme.applyThemeToString(CLICK_INFO, themeType.getLoreLine()));
        return new CustomItemStack(material, Theme.applyThemeToString(themeType, name), finalLore.toArray(new String[finalLore.size() - 1]));
    }
}

