/*
 * Decompiled with CFR 0.152.
 */
package dev.sefiraat.sefilib.slimefun;

import dev.sefiraat.sefilib.bstats.bukkit.Metrics;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class SimpleSlimefunAddon
extends JavaPlugin
implements SlimefunAddon {
    private static SimpleSlimefunAddon instance;

    @OverridingMethodsMustInvokeSuper
    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.tryUpdate();
        this.setupStats();
    }

    @Nonnull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    @Nonnull
    protected abstract String getGitHubUsername();

    @Nonnull
    protected abstract String getGitHubRepoName();

    @Nonnull
    protected abstract String getGitHubBranchName();

    protected abstract int getBStatsId();

    protected abstract boolean isAutoUpdate();

    private void setupStats() {
        if (this.getBStatsId() != 0) {
            Metrics metrics = new Metrics(this, this.getBStatsId());
        }
    }

    @Nullable
    public String getBugTrackerURL() {
        return MessageFormat.format("https://github.com/{0}/{1}/issues/", this.getGitHubUsername(), this.getGitHubRepoName());
    }

    private void tryUpdate() {
        if (this.isAutoUpdate() && this.getDescription().getVersion().startsWith("Dev")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), this.getGitHubRepoName(), "Dev").start();
        }
    }

    @Nonnull
    public static PluginManager getPluginManager() {
        return instance.getServer().getPluginManager();
    }

    public static void logError(@Nonnull String string) {
        instance.getLogger().severe(string);
    }

    public static void logWarning(@Nonnull String string) {
        instance.getLogger().warning(string);
    }

    public static void logInfo(@Nonnull String string) {
        instance.getLogger().info(string);
    }
}

