/*
 * Decompiled with CFR 0.152.
 */
package dev.sefiraat.sefilib.dough.versions;

import dev.sefiraat.sefilib.dough.versions.IncomparableVersionsException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;

public interface Version
extends Comparable<Version> {
    public boolean isNewerThan(@Nonnull Version var1);

    public boolean isEqualTo(@Nonnull Version var1);

    public boolean isOlderThan(@Nonnull Version var1);

    default public boolean isAtLeast(@Nonnull Version version) {
        Validate.notNull((Object)version, (String)"The version to compare must not be null.");
        return this.isEqualTo(version) || this.isNewerThan(version);
    }

    public boolean isSimilar(@Nonnull Version var1);

    @Nonnull
    public String getAsString();

    @Override
    default public int compareTo(@Nullable Version version) {
        if (version == null) {
            throw new NullPointerException("Cannot compare a version that is null");
        }
        if (this.isEqualTo(version)) {
            return 0;
        }
        if (this.isNewerThan(version)) {
            return 1;
        }
        if (this.isOlderThan(version)) {
            return -1;
        }
        throw new IncomparableVersionsException(this, version);
    }
}

