/*
 * Decompiled with CFR 0.152.
 */
package dev.sefiraat.sefilib.dough.protection.modules;

import dev.sefiraat.sefilib.dough.protection.Interaction;
import dev.sefiraat.sefilib.dough.protection.ProtectionModule;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.managers.IslandWorldManager;
import world.bentobox.bentobox.managers.IslandsManager;

public class BentoBoxProtectionModule
implements ProtectionModule {
    private IslandsManager manager;
    private IslandWorldManager iwm;
    private final Plugin plugin;

    public BentoBoxProtectionModule(@Nonnull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void load() {
        this.manager = BentoBox.getInstance().getIslands();
        this.iwm = BentoBox.getInstance().getIWM();
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, Location l, Interaction action) {
        Optional island = this.manager.getIslandAt(l);
        if (this.iwm.inWorld(l)) {
            Flag flag = this.convert(action, l.getWorld());
            if (island.isPresent()) {
                Island is = (Island)island.get();
                User user = User.getInstance((OfflinePlayer)p);
                return is.isAllowed(user, flag);
            }
            return flag.isSetForWorld(l.getWorld());
        }
        return true;
    }

    private Flag convert(Interaction action, World world) {
        switch (action) {
            case INTERACT_BLOCK: {
                return Flags.CONTAINER;
            }
            case ATTACK_PLAYER: {
                if (world.getEnvironment() == World.Environment.NETHER) {
                    return Flags.PVP_NETHER;
                }
                if (world.getEnvironment() == World.Environment.THE_END) {
                    return Flags.PVP_END;
                }
                return Flags.PVP_OVERWORLD;
            }
            case BREAK_BLOCK: {
                return Flags.BREAK_BLOCKS;
            }
            case ATTACK_ENTITY: {
                return Flags.HURT_ANIMALS;
            }
        }
        return Flags.PLACE_BLOCKS;
    }
}

