/*
 * Decompiled with CFR 0.152.
 */
package dev.sefiraat.sefilib.dough.items.nms;

import dev.sefiraat.sefilib.dough.common.DoughLogger;
import dev.sefiraat.sefilib.dough.items.nms.ItemNameAdapter17;
import dev.sefiraat.sefilib.dough.items.nms.ItemNameAdapter18;
import dev.sefiraat.sefilib.dough.items.nms.ItemNameAdapter18v2;
import dev.sefiraat.sefilib.dough.items.nms.ItemNameAdapter19;
import dev.sefiraat.sefilib.dough.items.nms.ItemNameAdapterBefore17;
import dev.sefiraat.sefilib.dough.items.nms.ItemNameAdapterMockBukkit;
import dev.sefiraat.sefilib.dough.versions.MinecraftVersion;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.inventory.ItemStack;

public interface ItemNameAdapter {
    @ParametersAreNonnullByDefault
    @Nonnull
    public String getName(ItemStack var1) throws IllegalAccessException, InvocationTargetException;

    @Nullable
    public static ItemNameAdapter get() {
        try {
            MinecraftVersion version = MinecraftVersion.get();
            if (MinecraftVersion.isMocked()) {
                return new ItemNameAdapterMockBukkit();
            }
            if (version.isAtLeast(1, 19)) {
                return new ItemNameAdapter19();
            }
            if (version.isAtLeast(1, 18, 2)) {
                return new ItemNameAdapter18v2();
            }
            if (version.isAtLeast(1, 18)) {
                return new ItemNameAdapter18();
            }
            if (version.isAtLeast(1, 17)) {
                return new ItemNameAdapter17();
            }
            return new ItemNameAdapterBefore17();
        }
        catch (Exception x) {
            DoughLogger logger = new DoughLogger("items");
            logger.log(Level.SEVERE, "Failed to detect items nbt methods", x);
            return null;
        }
    }
}

