/*
 * Decompiled with CFR 0.152.
 */
package dev.sefiraat.sefilib.dough.items;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class ItemStackSnapshot
extends ItemStack {
    private static final String ERROR_MESSAGE = "ItemStackSnapshots are immutable and not intended for actual usage.";
    private final ItemMeta meta;
    private final int amount;
    private final boolean hasItemMeta;

    private ItemStackSnapshot(@Nonnull ItemStack item) {
        super(item.getType());
        this.amount = item.getAmount();
        this.hasItemMeta = item.hasItemMeta();
        this.meta = this.hasItemMeta ? item.getItemMeta() : null;
    }

    public boolean hasItemMeta() {
        return this.hasItemMeta;
    }

    public ItemMeta getItemMeta() {
        if (this.meta == null) {
            throw new UnsupportedOperationException("This ItemStack has no ItemMeta! Make sure to check ItemStack#hasItemMeta() before accessing this method!");
        }
        return this.meta;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    public int hashCode() {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    public ItemStack clone() {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    public void setType(Material type) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    public void setAmount(int amount) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    public boolean setItemMeta(ItemMeta itemMeta) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    public void addUnsafeEnchantment(Enchantment ench, int level) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Nonnull
    public static ItemStackSnapshot forceWrap(@Nonnull ItemStack itemStack) {
        Validate.notNull((Object)itemStack, (String)"The ItemStack cannot be null!");
        return new ItemStackSnapshot(itemStack);
    }

    @Nonnull
    public static ItemStackSnapshot wrap(@Nonnull ItemStack itemStack) {
        Validate.notNull((Object)itemStack, (String)"The ItemStack cannot be null!");
        if (itemStack instanceof ItemStackSnapshot) {
            return (ItemStackSnapshot)itemStack;
        }
        return new ItemStackSnapshot(itemStack);
    }

    @Nonnull
    public static ItemStackSnapshot[] wrapArray(@Nonnull ItemStack[] items) {
        Validate.notNull((Object)items, (String)"The array must not be null!");
        ItemStackSnapshot[] array = new ItemStackSnapshot[items.length];
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            array[i] = ItemStackSnapshot.wrap(items[i]);
        }
        return array;
    }

    @Nonnull
    public static List<ItemStackSnapshot> wrapList(@Nonnull List<ItemStack> items) {
        Validate.notNull(items, (String)"The list must not be null!");
        ArrayList<ItemStackSnapshot> list = new ArrayList<ItemStackSnapshot>(items.size());
        for (ItemStack item : items) {
            if (item != null) {
                list.add(ItemStackSnapshot.wrap(item));
                continue;
            }
            list.add(null);
        }
        return list;
    }
}

