/*
 * Decompiled with CFR 0.152.
 */
package dev.sefiraat.sefilib.dough.data;

import dev.sefiraat.sefilib.dough.data.TriState;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TriStateOptional<T> {
    private TriState state;
    private T value;

    private TriStateOptional(TriState state) {
        this.state = state;
    }

    private TriStateOptional(T value) {
        this.state = TriState.COMPUTED;
        this.value = value;
    }

    @Nonnull
    public static <T> TriStateOptional<T> empty() {
        return new TriStateOptional<T>(TriState.EMPTY);
    }

    @Nonnull
    public static <T> TriStateOptional<T> createNew() {
        return new TriStateOptional<T>(TriState.NOT_COMPUTED);
    }

    @Nonnull
    public static <T> TriStateOptional<T> of(@Nonnull T value) {
        return new TriStateOptional<T>(value);
    }

    @Nonnull
    public static <T> TriStateOptional<T> ofNullable(@Nullable T value) {
        if (value == null) {
            return TriStateOptional.empty();
        }
        return new TriStateOptional<T>(value);
    }

    public boolean isEmpty() {
        return this.state == TriState.EMPTY;
    }

    public boolean isComputed() {
        return this.state != TriState.NOT_COMPUTED;
    }

    public boolean isPresent() {
        return this.state == TriState.COMPUTED;
    }

    public void ifPresent(@Nonnull Consumer<T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.value);
        }
    }

    public void compute(@Nullable T value) {
        if (this.isComputed()) {
            throw new IllegalStateException("This Optional has already been computed.");
        }
        if (value == null) {
            this.state = TriState.EMPTY;
        } else {
            this.state = TriState.COMPUTED;
            this.value = value;
        }
    }

    public void compute(@Nonnull Supplier<T> supplier) {
        this.compute(supplier.get());
    }

    @Nonnull
    public T get() {
        if (!this.isPresent()) {
            throw new IllegalAccessError("This Optional has no value! Check .isPresent() first!");
        }
        return this.value;
    }

    @Nullable
    public T getOrElse(@Nullable T value) {
        if (!this.isComputed()) {
            throw new IllegalStateException("This Optional has not yet been computed!");
        }
        return this.isPresent() ? this.value : value;
    }

    @Nonnull
    public Optional<T> getAsOptional() {
        if (!this.isComputed()) {
            throw new IllegalStateException("This Optional has not yet been computed!");
        }
        return this.isPresent() ? Optional.of(this.value) : Optional.empty();
    }
}

