/*
 * Decompiled with CFR 0.152.
 */
package dev.sefiraat.sefilib.dough.collections;

import dev.sefiraat.sefilib.dough.collections.OptionalPair;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Pair<P, S> {
    private P firstValue;
    private S secondValue;

    public Pair(P a, S b) {
        this.firstValue = a;
        this.secondValue = b;
    }

    public Pair(@Nonnull Map.Entry<P, S> mapEntry) {
        this(mapEntry.getKey(), mapEntry.getValue());
    }

    public Pair(@Nonnull OptionalPair<P, S> pair) {
        this(pair.getFirstValue().orElse(null), pair.getSecondValue().orElse(null));
    }

    @Nullable
    public P getFirstValue() {
        return this.firstValue;
    }

    @Nullable
    public S getSecondValue() {
        return this.secondValue;
    }

    public void setFirstValue(@Nullable P firstValue) {
        this.firstValue = firstValue;
    }

    public void setSecondValue(@Nullable S secondValue) {
        this.secondValue = secondValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        if (!Objects.equals(this.firstValue, other.firstValue)) {
            return false;
        }
        return Objects.equals(this.secondValue, other.secondValue);
    }

    public int hashCode() {
        int prime = 59;
        int result = 1;
        result = result * 59 + (this.firstValue == null ? 43 : this.firstValue.hashCode());
        result = result * 59 + (this.secondValue == null ? 43 : this.secondValue.hashCode());
        return result;
    }

    @Nonnull
    public String toString() {
        return "Pair(firstValue=" + this.firstValue + ", secondValue=" + this.secondValue + ")";
    }
}

