/*
 * Decompiled with CFR 0.152.
 */
package dev.sefiraat.sefilib.dough.collections;

import dev.sefiraat.sefilib.dough.collections.Pair;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OptionalPair<P, S> {
    private Optional<P> firstValue;
    private Optional<S> secondValue;

    public OptionalPair(@Nullable P a, @Nullable S b) {
        this.firstValue = Optional.ofNullable(a);
        this.secondValue = Optional.ofNullable(b);
    }

    public OptionalPair(@Nonnull Map.Entry<P, S> mapEntry) {
        this(mapEntry.getKey(), mapEntry.getValue());
    }

    public OptionalPair(@Nonnull Pair<P, S> pair) {
        this(pair.getFirstValue(), pair.getSecondValue());
    }

    @Nonnull
    public Optional<P> getFirstValue() {
        return this.firstValue;
    }

    @Nonnull
    public Optional<S> getSecondValue() {
        return this.secondValue;
    }

    public void setFirstValue(@Nullable P firstValue) {
        this.firstValue = Optional.ofNullable(firstValue);
    }

    public void setSecondValue(@Nullable S secondValue) {
        this.secondValue = Optional.ofNullable(secondValue);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptionalPair)) {
            return false;
        }
        OptionalPair other = (OptionalPair)o;
        if (!Objects.equals(this.firstValue, other.firstValue)) {
            return false;
        }
        return Objects.equals(this.secondValue, other.secondValue);
    }

    public int hashCode() {
        int prime = 59;
        int result = 1;
        result = result * 59 + (!this.firstValue.isPresent() ? 43 : this.firstValue.hashCode());
        result = result * 59 + (!this.secondValue.isPresent() ? 43 : this.secondValue.hashCode());
        return result;
    }

    @Nonnull
    public String toString() {
        return "OptionalPair(firstValue=" + this.firstValue + ", secondValue=" + this.secondValue + ")";
    }
}

