/*
 * Decompiled with CFR 0.152.
 */
package dev.sefiraat.sefilib.dough.collections;

import dev.sefiraat.sefilib.dough.collections.Streamable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public class OptionalMap<K, V>
implements Iterable<Map.Entry<K, V>>,
Streamable<Map.Entry<K, V>> {
    private Map<K, V> internalMap;

    public OptionalMap(@Nonnull Supplier<? extends Map<K, V>> constructor) {
        this.internalMap = constructor.get();
        if (this.internalMap == null) {
            throw new IllegalStateException("Internal Map is not allowed to be null!");
        }
    }

    public int size() {
        return this.internalMap.size();
    }

    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    public Optional<V> get(K key) {
        return Optional.ofNullable(this.internalMap.get(key));
    }

    public boolean containsKey(K key) {
        return this.get(key).isPresent();
    }

    public boolean containsValue(V value) {
        return this.internalMap.containsValue(value);
    }

    public void ifPresent(K key, Consumer<? super V> consumer) {
        this.get(key).ifPresent(consumer);
    }

    public void ifAbsent(K key, Consumer<Void> consumer) {
        if (!this.containsKey(key)) {
            consumer.accept(null);
        }
    }

    public Optional<V> put(K key, V value) {
        return Optional.ofNullable(this.internalMap.put(key, value));
    }

    public Optional<V> remove(K key) {
        return Optional.ofNullable(this.internalMap.remove(key));
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.internalMap.putAll(map);
    }

    public void clear() {
        this.internalMap.clear();
    }

    public Set<K> keySet() {
        return this.internalMap.keySet();
    }

    public Collection<V> values() {
        return this.internalMap.values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.internalMap.entrySet();
    }

    public boolean equals(Object obj) {
        return this.internalMap.equals(obj);
    }

    public int hashCode() {
        return this.internalMap.hashCode();
    }

    public V getOrDefault(K key, V defaultValue) {
        return this.internalMap.getOrDefault(key, defaultValue);
    }

    public void forEach(BiConsumer<? super K, ? super V> consumer) {
        this.internalMap.forEach(consumer);
    }

    public V putIfAbsent(K key, V value) {
        return this.internalMap.putIfAbsent(key, value);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> function) {
        return this.internalMap.computeIfAbsent((K)key, function);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> function) {
        return this.internalMap.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)function);
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> function) {
        return this.internalMap.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)function);
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> function) {
        return this.internalMap.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)function);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.entrySet().iterator();
    }

    @Override
    public Stream<Map.Entry<K, V>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Nonnull
    public Map<K, V> getInternalMap() {
        return this.internalMap;
    }
}

