/*
 * Decompiled with CFR 0.152.
 */
package dev.sefiraat.sefilib.dough.chat;

import dev.sefiraat.sefilib.dough.chat.ChatInputHandler;
import dev.sefiraat.sefilib.dough.chat.ChatInputListener;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class ChatInput {
    static ChatInputListener listener;

    private ChatInput() {
    }

    public static void waitForPlayer(@Nonnull Plugin plugin, @Nonnull Player p, @Nonnull Consumer<String> handler) {
        ChatInput.waitForPlayer(plugin, p, (String s) -> true, handler);
    }

    public static void waitForPlayer(@Nonnull Plugin plugin, @Nonnull Player p, final @Nonnull Predicate<String> predicate, final @Nonnull Consumer<String> handler) {
        ChatInput.queue(plugin, p, new ChatInputHandler(){

            @Override
            public boolean test(String msg) {
                return predicate.test(msg);
            }

            @Override
            public void onChat(Player p, String msg) {
                handler.accept(msg);
            }
        });
    }

    public static void waitForPlayer(@Nonnull Plugin plugin, @Nonnull Player p, @Nonnull BiConsumer<Player, String> handler) {
        ChatInput.waitForPlayer(plugin, p, (String s) -> true, handler);
    }

    public static void waitForPlayer(@Nonnull Plugin plugin, @Nonnull Player p, final @Nonnull Predicate<String> predicate, final @Nonnull BiConsumer<Player, String> handler) {
        ChatInput.queue(plugin, p, new ChatInputHandler(){

            @Override
            public boolean test(String msg) {
                return predicate.test(msg);
            }

            @Override
            public void onChat(Player p, String msg) {
                handler.accept(p, msg);
            }
        });
    }

    public static void queue(@Nonnull Plugin plugin, @Nonnull Player p, @Nonnull ChatInputHandler callback) {
        if (listener == null) {
            listener = new ChatInputListener(plugin);
        }
        listener.addCallback(p.getUniqueId(), callback);
    }
}

