/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.translation.Translatable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum GameMode implements Translatable
{
    CREATIVE(1),
    SURVIVAL(0),
    ADVENTURE(2),
    SPECTATOR(3);

    private final int value;
    private static final Map<Integer, GameMode> BY_ID;
    private final String translationKey;

    @NotNull
    public String translationKey() {
        return this.translationKey;
    }

    private GameMode(int value) {
        this.value = value;
        this.translationKey = "gameMode." + this.name().toLowerCase(Locale.ENGLISH);
    }

    @ApiStatus.Internal
    public int getValue() {
        return this.value;
    }

    @ApiStatus.Internal
    @Nullable
    public static GameMode getByValue(int value) {
        return BY_ID.get(value);
    }

    public boolean isInvulnerable() {
        return this == CREATIVE || this == SPECTATOR;
    }

    static {
        BY_ID = Maps.newHashMap();
        for (GameMode mode : GameMode.values()) {
            BY_ID.put(mode.getValue(), mode);
        }
    }
}

