package io.papermc.paper.registry.keys.tags;

import static net.kyori.adventure.key.Key.key;

import io.papermc.paper.generated.GeneratedFrom;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.tag.TagKey;
import net.kyori.adventure.key.Key;
import org.bukkit.block.BlockType;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

/**
 * Vanilla tag keys for {@link RegistryKey#BLOCK}.
 *
 * @apiNote The fields provided here are a direct representation of
 * what is available from the vanilla game source. They may be
 * changed (including removals) on any Minecraft version
 * bump, so cross-version compatibility is not provided on the
 * same level as it is on most of the other API.
 */
@SuppressWarnings({
        "unused",
        "SpellCheckingInspection"
})
@NullMarked
@GeneratedFrom("1.21.6")
@ApiStatus.Experimental
public final class BlockTypeTagKeys {
    /**
     * {@code #minecraft:acacia_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> ACACIA_LOGS = create(key("acacia_logs"));

    /**
     * {@code #minecraft:air}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> AIR = create(key("air"));

    /**
     * {@code #minecraft:all_hanging_signs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> ALL_HANGING_SIGNS = create(key("all_hanging_signs"));

    /**
     * {@code #minecraft:all_signs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> ALL_SIGNS = create(key("all_signs"));

    /**
     * {@code #minecraft:ancient_city_replaceable}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> ANCIENT_CITY_REPLACEABLE = create(key("ancient_city_replaceable"));

    /**
     * {@code #minecraft:animals_spawnable_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> ANIMALS_SPAWNABLE_ON = create(key("animals_spawnable_on"));

    /**
     * {@code #minecraft:anvil}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> ANVIL = create(key("anvil"));

    /**
     * {@code #minecraft:armadillo_spawnable_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> ARMADILLO_SPAWNABLE_ON = create(key("armadillo_spawnable_on"));

    /**
     * {@code #minecraft:axolotls_spawnable_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> AXOLOTLS_SPAWNABLE_ON = create(key("axolotls_spawnable_on"));

    /**
     * {@code #minecraft:azalea_grows_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> AZALEA_GROWS_ON = create(key("azalea_grows_on"));

    /**
     * {@code #minecraft:azalea_root_replaceable}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> AZALEA_ROOT_REPLACEABLE = create(key("azalea_root_replaceable"));

    /**
     * {@code #minecraft:badlands_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> BADLANDS_TERRACOTTA = create(key("badlands_terracotta"));

    /**
     * {@code #minecraft:bamboo_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> BAMBOO_BLOCKS = create(key("bamboo_blocks"));

    /**
     * {@code #minecraft:bamboo_plantable_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> BAMBOO_PLANTABLE_ON = create(key("bamboo_plantable_on"));

    /**
     * {@code #minecraft:banners}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> BANNERS = create(key("banners"));

    /**
     * {@code #minecraft:base_stone_nether}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> BASE_STONE_NETHER = create(key("base_stone_nether"));

    /**
     * {@code #minecraft:base_stone_overworld}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> BASE_STONE_OVERWORLD = create(key("base_stone_overworld"));

    /**
     * {@code #minecraft:bats_spawnable_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> BATS_SPAWNABLE_ON = create(key("bats_spawnable_on"));

    /**
     * {@code #minecraft:beacon_base_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> BEACON_BASE_BLOCKS = create(key("beacon_base_blocks"));

    /**
     * {@code #minecraft:beds}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> BEDS = create(key("beds"));

    /**
     * {@code #minecraft:bee_attractive}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> BEE_ATTRACTIVE = create(key("bee_attractive"));

    /**
     * {@code #minecraft:bee_growables}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> BEE_GROWABLES = create(key("bee_growables"));

    /**
     * {@code #minecraft:beehives}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> BEEHIVES = create(key("beehives"));

    /**
     * {@code #minecraft:big_dripleaf_placeable}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> BIG_DRIPLEAF_PLACEABLE = create(key("big_dripleaf_placeable"));

    /**
     * {@code #minecraft:birch_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> BIRCH_LOGS = create(key("birch_logs"));

    /**
     * {@code #minecraft:blocks_wind_charge_explosions}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> BLOCKS_WIND_CHARGE_EXPLOSIONS = create(key("blocks_wind_charge_explosions"));

    /**
     * {@code #minecraft:buttons}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> BUTTONS = create(key("buttons"));

    /**
     * {@code #minecraft:camel_sand_step_sound_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CAMEL_SAND_STEP_SOUND_BLOCKS = create(key("camel_sand_step_sound_blocks"));

    /**
     * {@code #minecraft:camels_spawnable_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CAMELS_SPAWNABLE_ON = create(key("camels_spawnable_on"));

    /**
     * {@code #minecraft:campfires}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CAMPFIRES = create(key("campfires"));

    /**
     * {@code #minecraft:candle_cakes}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CANDLE_CAKES = create(key("candle_cakes"));

    /**
     * {@code #minecraft:candles}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CANDLES = create(key("candles"));

    /**
     * {@code #minecraft:cauldrons}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CAULDRONS = create(key("cauldrons"));

    /**
     * {@code #minecraft:cave_vines}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CAVE_VINES = create(key("cave_vines"));

    /**
     * {@code #minecraft:ceiling_hanging_signs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CEILING_HANGING_SIGNS = create(key("ceiling_hanging_signs"));

    /**
     * {@code #minecraft:cherry_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CHERRY_LOGS = create(key("cherry_logs"));

    /**
     * {@code #minecraft:climbable}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CLIMBABLE = create(key("climbable"));

    /**
     * {@code #minecraft:coal_ores}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> COAL_ORES = create(key("coal_ores"));

    /**
     * {@code #minecraft:combination_step_sound_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> COMBINATION_STEP_SOUND_BLOCKS = create(key("combination_step_sound_blocks"));

    /**
     * {@code #minecraft:completes_find_tree_tutorial}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> COMPLETES_FIND_TREE_TUTORIAL = create(key("completes_find_tree_tutorial"));

    /**
     * {@code #minecraft:concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CONCRETE_POWDER = create(key("concrete_powder"));

    /**
     * {@code #minecraft:convertable_to_mud}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CONVERTABLE_TO_MUD = create(key("convertable_to_mud"));

    /**
     * {@code #minecraft:copper_ores}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> COPPER_ORES = create(key("copper_ores"));

    /**
     * {@code #minecraft:coral_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CORAL_BLOCKS = create(key("coral_blocks"));

    /**
     * {@code #minecraft:coral_plants}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CORAL_PLANTS = create(key("coral_plants"));

    /**
     * {@code #minecraft:corals}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CORALS = create(key("corals"));

    /**
     * {@code #minecraft:crimson_stems}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CRIMSON_STEMS = create(key("crimson_stems"));

    /**
     * {@code #minecraft:crops}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CROPS = create(key("crops"));

    /**
     * {@code #minecraft:crystal_sound_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> CRYSTAL_SOUND_BLOCKS = create(key("crystal_sound_blocks"));

    /**
     * {@code #minecraft:dampens_vibrations}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> DAMPENS_VIBRATIONS = create(key("dampens_vibrations"));

    /**
     * {@code #minecraft:dark_oak_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> DARK_OAK_LOGS = create(key("dark_oak_logs"));

    /**
     * {@code #minecraft:deepslate_ore_replaceables}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> DEEPSLATE_ORE_REPLACEABLES = create(key("deepslate_ore_replaceables"));

    /**
     * {@code #minecraft:diamond_ores}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> DIAMOND_ORES = create(key("diamond_ores"));

    /**
     * {@code #minecraft:dirt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> DIRT = create(key("dirt"));

    /**
     * {@code #minecraft:does_not_block_hoppers}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> DOES_NOT_BLOCK_HOPPERS = create(key("does_not_block_hoppers"));

    /**
     * {@code #minecraft:doors}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> DOORS = create(key("doors"));

    /**
     * {@code #minecraft:dragon_immune}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> DRAGON_IMMUNE = create(key("dragon_immune"));

    /**
     * {@code #minecraft:dragon_transparent}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> DRAGON_TRANSPARENT = create(key("dragon_transparent"));

    /**
     * {@code #minecraft:dripstone_replaceable_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> DRIPSTONE_REPLACEABLE_BLOCKS = create(key("dripstone_replaceable_blocks"));

    /**
     * {@code #minecraft:dry_vegetation_may_place_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> DRY_VEGETATION_MAY_PLACE_ON = create(key("dry_vegetation_may_place_on"));

    /**
     * {@code #minecraft:edible_for_sheep}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> EDIBLE_FOR_SHEEP = create(key("edible_for_sheep"));

    /**
     * {@code #minecraft:emerald_ores}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> EMERALD_ORES = create(key("emerald_ores"));

    /**
     * {@code #minecraft:enchantment_power_provider}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> ENCHANTMENT_POWER_PROVIDER = create(key("enchantment_power_provider"));

    /**
     * {@code #minecraft:enchantment_power_transmitter}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> ENCHANTMENT_POWER_TRANSMITTER = create(key("enchantment_power_transmitter"));

    /**
     * {@code #minecraft:enderman_holdable}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> ENDERMAN_HOLDABLE = create(key("enderman_holdable"));

    /**
     * {@code #minecraft:fall_damage_resetting}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> FALL_DAMAGE_RESETTING = create(key("fall_damage_resetting"));

    /**
     * {@code #minecraft:features_cannot_replace}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> FEATURES_CANNOT_REPLACE = create(key("features_cannot_replace"));

    /**
     * {@code #minecraft:fence_gates}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> FENCE_GATES = create(key("fence_gates"));

    /**
     * {@code #minecraft:fences}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> FENCES = create(key("fences"));

    /**
     * {@code #minecraft:fire}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> FIRE = create(key("fire"));

    /**
     * {@code #minecraft:flower_pots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> FLOWER_POTS = create(key("flower_pots"));

    /**
     * {@code #minecraft:flowers}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> FLOWERS = create(key("flowers"));

    /**
     * {@code #minecraft:foxes_spawnable_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> FOXES_SPAWNABLE_ON = create(key("foxes_spawnable_on"));

    /**
     * {@code #minecraft:frog_prefer_jump_to}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> FROG_PREFER_JUMP_TO = create(key("frog_prefer_jump_to"));

    /**
     * {@code #minecraft:frogs_spawnable_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> FROGS_SPAWNABLE_ON = create(key("frogs_spawnable_on"));

    /**
     * {@code #minecraft:geode_invalid_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> GEODE_INVALID_BLOCKS = create(key("geode_invalid_blocks"));

    /**
     * {@code #minecraft:goats_spawnable_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> GOATS_SPAWNABLE_ON = create(key("goats_spawnable_on"));

    /**
     * {@code #minecraft:gold_ores}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> GOLD_ORES = create(key("gold_ores"));

    /**
     * {@code #minecraft:guarded_by_piglins}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> GUARDED_BY_PIGLINS = create(key("guarded_by_piglins"));

    /**
     * {@code #minecraft:happy_ghast_avoids}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> HAPPY_GHAST_AVOIDS = create(key("happy_ghast_avoids"));

    /**
     * {@code #minecraft:hoglin_repellents}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> HOGLIN_REPELLENTS = create(key("hoglin_repellents"));

    /**
     * {@code #minecraft:ice}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> ICE = create(key("ice"));

    /**
     * {@code #minecraft:impermeable}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> IMPERMEABLE = create(key("impermeable"));

    /**
     * {@code #minecraft:incorrect_for_diamond_tool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> INCORRECT_FOR_DIAMOND_TOOL = create(key("incorrect_for_diamond_tool"));

    /**
     * {@code #minecraft:incorrect_for_gold_tool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> INCORRECT_FOR_GOLD_TOOL = create(key("incorrect_for_gold_tool"));

    /**
     * {@code #minecraft:incorrect_for_iron_tool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> INCORRECT_FOR_IRON_TOOL = create(key("incorrect_for_iron_tool"));

    /**
     * {@code #minecraft:incorrect_for_netherite_tool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> INCORRECT_FOR_NETHERITE_TOOL = create(key("incorrect_for_netherite_tool"));

    /**
     * {@code #minecraft:incorrect_for_stone_tool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> INCORRECT_FOR_STONE_TOOL = create(key("incorrect_for_stone_tool"));

    /**
     * {@code #minecraft:incorrect_for_wooden_tool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> INCORRECT_FOR_WOODEN_TOOL = create(key("incorrect_for_wooden_tool"));

    /**
     * {@code #minecraft:infiniburn_end}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> INFINIBURN_END = create(key("infiniburn_end"));

    /**
     * {@code #minecraft:infiniburn_nether}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> INFINIBURN_NETHER = create(key("infiniburn_nether"));

    /**
     * {@code #minecraft:infiniburn_overworld}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> INFINIBURN_OVERWORLD = create(key("infiniburn_overworld"));

    /**
     * {@code #minecraft:inside_step_sound_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> INSIDE_STEP_SOUND_BLOCKS = create(key("inside_step_sound_blocks"));

    /**
     * {@code #minecraft:invalid_spawn_inside}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> INVALID_SPAWN_INSIDE = create(key("invalid_spawn_inside"));

    /**
     * {@code #minecraft:iron_ores}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> IRON_ORES = create(key("iron_ores"));

    /**
     * {@code #minecraft:jungle_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> JUNGLE_LOGS = create(key("jungle_logs"));

    /**
     * {@code #minecraft:lapis_ores}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> LAPIS_ORES = create(key("lapis_ores"));

    /**
     * {@code #minecraft:lava_pool_stone_cannot_replace}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> LAVA_POOL_STONE_CANNOT_REPLACE = create(key("lava_pool_stone_cannot_replace"));

    /**
     * {@code #minecraft:leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> LEAVES = create(key("leaves"));

    /**
     * {@code #minecraft:logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> LOGS = create(key("logs"));

    /**
     * {@code #minecraft:logs_that_burn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> LOGS_THAT_BURN = create(key("logs_that_burn"));

    /**
     * {@code #minecraft:lush_ground_replaceable}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> LUSH_GROUND_REPLACEABLE = create(key("lush_ground_replaceable"));

    /**
     * {@code #minecraft:maintains_farmland}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> MAINTAINS_FARMLAND = create(key("maintains_farmland"));

    /**
     * {@code #minecraft:mangrove_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> MANGROVE_LOGS = create(key("mangrove_logs"));

    /**
     * {@code #minecraft:mangrove_logs_can_grow_through}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> MANGROVE_LOGS_CAN_GROW_THROUGH = create(key("mangrove_logs_can_grow_through"));

    /**
     * {@code #minecraft:mangrove_roots_can_grow_through}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> MANGROVE_ROOTS_CAN_GROW_THROUGH = create(key("mangrove_roots_can_grow_through"));

    /**
     * {@code #minecraft:mineable/axe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> MINEABLE_AXE = create(key("mineable/axe"));

    /**
     * {@code #minecraft:mineable/hoe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> MINEABLE_HOE = create(key("mineable/hoe"));

    /**
     * {@code #minecraft:mineable/pickaxe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> MINEABLE_PICKAXE = create(key("mineable/pickaxe"));

    /**
     * {@code #minecraft:mineable/shovel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> MINEABLE_SHOVEL = create(key("mineable/shovel"));

    /**
     * {@code #minecraft:mob_interactable_doors}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> MOB_INTERACTABLE_DOORS = create(key("mob_interactable_doors"));

    /**
     * {@code #minecraft:mooshrooms_spawnable_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> MOOSHROOMS_SPAWNABLE_ON = create(key("mooshrooms_spawnable_on"));

    /**
     * {@code #minecraft:moss_replaceable}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> MOSS_REPLACEABLE = create(key("moss_replaceable"));

    /**
     * {@code #minecraft:mushroom_grow_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> MUSHROOM_GROW_BLOCK = create(key("mushroom_grow_block"));

    /**
     * {@code #minecraft:needs_diamond_tool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> NEEDS_DIAMOND_TOOL = create(key("needs_diamond_tool"));

    /**
     * {@code #minecraft:needs_iron_tool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> NEEDS_IRON_TOOL = create(key("needs_iron_tool"));

    /**
     * {@code #minecraft:needs_stone_tool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> NEEDS_STONE_TOOL = create(key("needs_stone_tool"));

    /**
     * {@code #minecraft:nether_carver_replaceables}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> NETHER_CARVER_REPLACEABLES = create(key("nether_carver_replaceables"));

    /**
     * {@code #minecraft:nylium}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> NYLIUM = create(key("nylium"));

    /**
     * {@code #minecraft:oak_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> OAK_LOGS = create(key("oak_logs"));

    /**
     * {@code #minecraft:occludes_vibration_signals}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> OCCLUDES_VIBRATION_SIGNALS = create(key("occludes_vibration_signals"));

    /**
     * {@code #minecraft:overworld_carver_replaceables}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> OVERWORLD_CARVER_REPLACEABLES = create(key("overworld_carver_replaceables"));

    /**
     * {@code #minecraft:overworld_natural_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> OVERWORLD_NATURAL_LOGS = create(key("overworld_natural_logs"));

    /**
     * {@code #minecraft:pale_oak_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> PALE_OAK_LOGS = create(key("pale_oak_logs"));

    /**
     * {@code #minecraft:parrots_spawnable_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> PARROTS_SPAWNABLE_ON = create(key("parrots_spawnable_on"));

    /**
     * {@code #minecraft:piglin_repellents}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> PIGLIN_REPELLENTS = create(key("piglin_repellents"));

    /**
     * {@code #minecraft:planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> PLANKS = create(key("planks"));

    /**
     * {@code #minecraft:polar_bears_spawnable_on_alternate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> POLAR_BEARS_SPAWNABLE_ON_ALTERNATE = create(key("polar_bears_spawnable_on_alternate"));

    /**
     * {@code #minecraft:portals}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> PORTALS = create(key("portals"));

    /**
     * {@code #minecraft:pressure_plates}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> PRESSURE_PLATES = create(key("pressure_plates"));

    /**
     * {@code #minecraft:prevent_mob_spawning_inside}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> PREVENT_MOB_SPAWNING_INSIDE = create(key("prevent_mob_spawning_inside"));

    /**
     * {@code #minecraft:rabbits_spawnable_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> RABBITS_SPAWNABLE_ON = create(key("rabbits_spawnable_on"));

    /**
     * {@code #minecraft:rails}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> RAILS = create(key("rails"));

    /**
     * {@code #minecraft:redstone_ores}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> REDSTONE_ORES = create(key("redstone_ores"));

    /**
     * {@code #minecraft:replaceable}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> REPLACEABLE = create(key("replaceable"));

    /**
     * {@code #minecraft:replaceable_by_mushrooms}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> REPLACEABLE_BY_MUSHROOMS = create(key("replaceable_by_mushrooms"));

    /**
     * {@code #minecraft:replaceable_by_trees}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> REPLACEABLE_BY_TREES = create(key("replaceable_by_trees"));

    /**
     * {@code #minecraft:sand}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SAND = create(key("sand"));

    /**
     * {@code #minecraft:saplings}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SAPLINGS = create(key("saplings"));

    /**
     * {@code #minecraft:sculk_replaceable}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SCULK_REPLACEABLE = create(key("sculk_replaceable"));

    /**
     * {@code #minecraft:sculk_replaceable_world_gen}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SCULK_REPLACEABLE_WORLD_GEN = create(key("sculk_replaceable_world_gen"));

    /**
     * {@code #minecraft:shulker_boxes}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SHULKER_BOXES = create(key("shulker_boxes"));

    /**
     * {@code #minecraft:signs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SIGNS = create(key("signs"));

    /**
     * {@code #minecraft:slabs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SLABS = create(key("slabs"));

    /**
     * {@code #minecraft:small_dripleaf_placeable}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SMALL_DRIPLEAF_PLACEABLE = create(key("small_dripleaf_placeable"));

    /**
     * {@code #minecraft:small_flowers}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SMALL_FLOWERS = create(key("small_flowers"));

    /**
     * {@code #minecraft:smelts_to_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SMELTS_TO_GLASS = create(key("smelts_to_glass"));

    /**
     * {@code #minecraft:snaps_goat_horn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SNAPS_GOAT_HORN = create(key("snaps_goat_horn"));

    /**
     * {@code #minecraft:sniffer_diggable_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SNIFFER_DIGGABLE_BLOCK = create(key("sniffer_diggable_block"));

    /**
     * {@code #minecraft:sniffer_egg_hatch_boost}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SNIFFER_EGG_HATCH_BOOST = create(key("sniffer_egg_hatch_boost"));

    /**
     * {@code #minecraft:snow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SNOW = create(key("snow"));

    /**
     * {@code #minecraft:snow_layer_can_survive_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SNOW_LAYER_CAN_SURVIVE_ON = create(key("snow_layer_can_survive_on"));

    /**
     * {@code #minecraft:snow_layer_cannot_survive_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SNOW_LAYER_CANNOT_SURVIVE_ON = create(key("snow_layer_cannot_survive_on"));

    /**
     * {@code #minecraft:soul_fire_base_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SOUL_FIRE_BASE_BLOCKS = create(key("soul_fire_base_blocks"));

    /**
     * {@code #minecraft:soul_speed_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SOUL_SPEED_BLOCKS = create(key("soul_speed_blocks"));

    /**
     * {@code #minecraft:spruce_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SPRUCE_LOGS = create(key("spruce_logs"));

    /**
     * {@code #minecraft:stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> STAIRS = create(key("stairs"));

    /**
     * {@code #minecraft:standing_signs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> STANDING_SIGNS = create(key("standing_signs"));

    /**
     * {@code #minecraft:stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> STONE_BRICKS = create(key("stone_bricks"));

    /**
     * {@code #minecraft:stone_buttons}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> STONE_BUTTONS = create(key("stone_buttons"));

    /**
     * {@code #minecraft:stone_ore_replaceables}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> STONE_ORE_REPLACEABLES = create(key("stone_ore_replaceables"));

    /**
     * {@code #minecraft:stone_pressure_plates}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> STONE_PRESSURE_PLATES = create(key("stone_pressure_plates"));

    /**
     * {@code #minecraft:strider_warm_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> STRIDER_WARM_BLOCKS = create(key("strider_warm_blocks"));

    /**
     * {@code #minecraft:sword_efficient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SWORD_EFFICIENT = create(key("sword_efficient"));

    /**
     * {@code #minecraft:sword_instantly_mines}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> SWORD_INSTANTLY_MINES = create(key("sword_instantly_mines"));

    /**
     * {@code #minecraft:terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> TERRACOTTA = create(key("terracotta"));

    /**
     * {@code #minecraft:trail_ruins_replaceable}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> TRAIL_RUINS_REPLACEABLE = create(key("trail_ruins_replaceable"));

    /**
     * {@code #minecraft:trapdoors}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> TRAPDOORS = create(key("trapdoors"));

    /**
     * {@code #minecraft:triggers_ambient_desert_dry_vegetation_block_sounds}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> TRIGGERS_AMBIENT_DESERT_DRY_VEGETATION_BLOCK_SOUNDS = create(key("triggers_ambient_desert_dry_vegetation_block_sounds"));

    /**
     * {@code #minecraft:triggers_ambient_desert_sand_block_sounds}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> TRIGGERS_AMBIENT_DESERT_SAND_BLOCK_SOUNDS = create(key("triggers_ambient_desert_sand_block_sounds"));

    /**
     * {@code #minecraft:triggers_ambient_dried_ghast_block_sounds}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> TRIGGERS_AMBIENT_DRIED_GHAST_BLOCK_SOUNDS = create(key("triggers_ambient_dried_ghast_block_sounds"));

    /**
     * {@code #minecraft:underwater_bonemeals}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> UNDERWATER_BONEMEALS = create(key("underwater_bonemeals"));

    /**
     * {@code #minecraft:unstable_bottom_center}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> UNSTABLE_BOTTOM_CENTER = create(key("unstable_bottom_center"));

    /**
     * {@code #minecraft:valid_spawn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> VALID_SPAWN = create(key("valid_spawn"));

    /**
     * {@code #minecraft:vibration_resonators}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> VIBRATION_RESONATORS = create(key("vibration_resonators"));

    /**
     * {@code #minecraft:wall_corals}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WALL_CORALS = create(key("wall_corals"));

    /**
     * {@code #minecraft:wall_hanging_signs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WALL_HANGING_SIGNS = create(key("wall_hanging_signs"));

    /**
     * {@code #minecraft:wall_post_override}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WALL_POST_OVERRIDE = create(key("wall_post_override"));

    /**
     * {@code #minecraft:wall_signs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WALL_SIGNS = create(key("wall_signs"));

    /**
     * {@code #minecraft:walls}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WALLS = create(key("walls"));

    /**
     * {@code #minecraft:warped_stems}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WARPED_STEMS = create(key("warped_stems"));

    /**
     * {@code #minecraft:wart_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WART_BLOCKS = create(key("wart_blocks"));

    /**
     * {@code #minecraft:wither_immune}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WITHER_IMMUNE = create(key("wither_immune"));

    /**
     * {@code #minecraft:wither_summon_base_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WITHER_SUMMON_BASE_BLOCKS = create(key("wither_summon_base_blocks"));

    /**
     * {@code #minecraft:wolves_spawnable_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WOLVES_SPAWNABLE_ON = create(key("wolves_spawnable_on"));

    /**
     * {@code #minecraft:wooden_buttons}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WOODEN_BUTTONS = create(key("wooden_buttons"));

    /**
     * {@code #minecraft:wooden_doors}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WOODEN_DOORS = create(key("wooden_doors"));

    /**
     * {@code #minecraft:wooden_fences}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WOODEN_FENCES = create(key("wooden_fences"));

    /**
     * {@code #minecraft:wooden_pressure_plates}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WOODEN_PRESSURE_PLATES = create(key("wooden_pressure_plates"));

    /**
     * {@code #minecraft:wooden_slabs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WOODEN_SLABS = create(key("wooden_slabs"));

    /**
     * {@code #minecraft:wooden_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WOODEN_STAIRS = create(key("wooden_stairs"));

    /**
     * {@code #minecraft:wooden_trapdoors}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WOODEN_TRAPDOORS = create(key("wooden_trapdoors"));

    /**
     * {@code #minecraft:wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WOOL = create(key("wool"));

    /**
     * {@code #minecraft:wool_carpets}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<BlockType> WOOL_CARPETS = create(key("wool_carpets"));

    private BlockTypeTagKeys() {
    }

    /**
     * Creates a tag key for {@link BlockType} in the registry {@code minecraft:block}.
     *
     * @param key the tag key's key
     * @return a new tag key
     */
    @ApiStatus.Experimental
    public static TagKey<BlockType> create(final Key key) {
        return TagKey.create(RegistryKey.BLOCK, key);
    }
}
