/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.player;

import com.google.common.base.Preconditions;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PlayerHandshakeEvent
extends Event
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final String originalHandshake;
    private final String originalSocketAddressHostname;
    private @Nullable String serverHostname;
    private @Nullable String socketAddressHostname;
    private @Nullable UUID uniqueId;
    private @Nullable String propertiesJson;
    private boolean failed;
    private Component failMessage = Component.text((String)"If you wish to use IP forwarding, please enable it in your BungeeCord config as well!", (TextColor)NamedTextColor.YELLOW);
    private boolean cancelled;

    @Deprecated
    @ApiStatus.Internal
    public PlayerHandshakeEvent(String originalHandshake, boolean cancelled) {
        this(originalHandshake, "127.0.0.1", cancelled);
    }

    @ApiStatus.Internal
    public PlayerHandshakeEvent(String originalHandshake, String originalSocketAddressHostname, boolean cancelled) {
        super(true);
        this.originalHandshake = originalHandshake;
        this.originalSocketAddressHostname = originalSocketAddressHostname;
        this.cancelled = cancelled;
    }

    public String getOriginalHandshake() {
        return this.originalHandshake;
    }

    public String getOriginalSocketAddressHostname() {
        return this.originalSocketAddressHostname;
    }

    public @Nullable String getServerHostname() {
        return this.serverHostname;
    }

    public void setServerHostname(String serverHostname) {
        this.serverHostname = serverHostname;
    }

    public @Nullable String getSocketAddressHostname() {
        return this.socketAddressHostname;
    }

    public void setSocketAddressHostname(String socketAddressHostname) {
        this.socketAddressHostname = socketAddressHostname;
    }

    public @Nullable UUID getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    public @Nullable String getPropertiesJson() {
        return this.propertiesJson;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public void setPropertiesJson(String propertiesJson) {
        this.propertiesJson = propertiesJson;
    }

    public Component failMessage() {
        return this.failMessage;
    }

    public void failMessage(Component failMessage) {
        this.failMessage = failMessage;
    }

    @Deprecated
    public String getFailMessage() {
        return LegacyComponentSerializer.legacySection().serialize(this.failMessage());
    }

    @Deprecated
    public void setFailMessage(String failMessage) {
        Preconditions.checkArgument((failMessage != null && !failMessage.isEmpty() ? 1 : 0) != 0, (Object)"fail message cannot be null or empty");
        this.failMessage((Component)LegacyComponentSerializer.legacySection().deserialize(failMessage));
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

