/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.entity;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerDeathEvent
extends EntityDeathEvent {
    private int newExp = 0;
    private Component deathMessage;
    private int newLevel = 0;
    private int newTotalExp = 0;
    private boolean keepLevel = false;
    private boolean keepInventory = false;
    private boolean doExpDrop;
    @Deprecated
    private List<ItemStack> itemsToKeep = new ArrayList<ItemStack>();

    @ApiStatus.Internal
    public PlayerDeathEvent(@NotNull Player player, @NotNull DamageSource damageSource, @NotNull List<ItemStack> drops, int droppedExp, @Nullable Component deathMessage) {
        this(player, damageSource, drops, droppedExp, 0, deathMessage);
    }

    @ApiStatus.Internal
    public PlayerDeathEvent(@NotNull Player player, @NotNull DamageSource damageSource, @NotNull List<ItemStack> drops, int droppedExp, int newExp, @Nullable Component deathMessage) {
        this(player, damageSource, drops, droppedExp, newExp, 0, 0, deathMessage);
    }

    @ApiStatus.Internal
    public PlayerDeathEvent(@NotNull Player player, @NotNull DamageSource damageSource, @NotNull List<ItemStack> drops, int droppedExp, int newExp, int newTotalExp, int newLevel, @Nullable Component deathMessage) {
        this(player, damageSource, drops, droppedExp, newExp, newTotalExp, newLevel, deathMessage, true);
    }

    @ApiStatus.Internal
    public PlayerDeathEvent(@NotNull Player player, @NotNull DamageSource damageSource, @NotNull List<ItemStack> drops, int droppedExp, int newExp, int newTotalExp, int newLevel, @Nullable Component deathMessage, boolean doExpDrop) {
        super(player, damageSource, drops, droppedExp);
        this.newExp = newExp;
        this.newTotalExp = newTotalExp;
        this.newLevel = newLevel;
        this.deathMessage = deathMessage;
        this.doExpDrop = doExpDrop;
    }

    @Deprecated(forRemoval=true)
    public PlayerDeathEvent(@NotNull Player player, @NotNull DamageSource damageSource, @NotNull List<ItemStack> drops, int droppedExp, @Nullable String deathMessage) {
        this(player, damageSource, drops, droppedExp, 0, deathMessage);
    }

    @Deprecated(forRemoval=true)
    public PlayerDeathEvent(@NotNull Player player, @NotNull DamageSource damageSource, @NotNull List<ItemStack> drops, int droppedExp, int newExp, @Nullable String deathMessage) {
        this(player, damageSource, drops, droppedExp, newExp, 0, 0, deathMessage);
    }

    @Deprecated(forRemoval=true)
    public PlayerDeathEvent(@NotNull Player player, @NotNull DamageSource damageSource, @NotNull List<ItemStack> drops, int droppedExp, int newExp, int newTotalExp, int newLevel, @Nullable String deathMessage) {
        this(player, damageSource, drops, droppedExp, newExp, newTotalExp, newLevel, deathMessage, true);
    }

    @Deprecated(forRemoval=true)
    public PlayerDeathEvent(@NotNull Player player, @NotNull DamageSource damageSource, @NotNull List<ItemStack> drops, int droppedExp, int newExp, int newTotalExp, int newLevel, @Nullable String deathMessage, boolean doExpDrop) {
        super(player, damageSource, drops, droppedExp);
        this.newExp = newExp;
        this.newTotalExp = newTotalExp;
        this.newLevel = newLevel;
        this.deathMessage = LegacyComponentSerializer.legacySection().deserializeOrNull((Object)deathMessage);
        this.doExpDrop = doExpDrop;
    }

    @NotNull
    public List<ItemStack> getItemsToKeep() {
        return this.itemsToKeep;
    }

    public boolean shouldDropExperience() {
        return this.doExpDrop;
    }

    public void setShouldDropExperience(boolean doExpDrop) {
        this.doExpDrop = doExpDrop;
    }

    @Override
    @NotNull
    public Player getEntity() {
        return (Player)this.entity;
    }

    @NotNull
    public Player getPlayer() {
        return this.getEntity();
    }

    public void deathMessage(@Nullable Component deathMessage) {
        this.deathMessage = deathMessage;
    }

    public @Nullable Component deathMessage() {
        return this.deathMessage;
    }

    @Deprecated
    public void setDeathMessage(@Nullable String deathMessage) {
        this.deathMessage = LegacyComponentSerializer.legacySection().deserializeOrNull((Object)deathMessage);
    }

    @Deprecated
    @Nullable
    public String getDeathMessage() {
        return (String)LegacyComponentSerializer.legacySection().serializeOrNull(this.deathMessage);
    }

    public int getNewExp() {
        return this.newExp;
    }

    public void setNewExp(int exp) {
        this.newExp = exp;
    }

    public int getNewLevel() {
        return this.newLevel;
    }

    public void setNewLevel(int level) {
        this.newLevel = level;
    }

    public int getNewTotalExp() {
        return this.newTotalExp;
    }

    public void setNewTotalExp(int totalExp) {
        this.newTotalExp = totalExp;
    }

    public boolean getKeepLevel() {
        return this.keepLevel;
    }

    public void setKeepLevel(boolean keepLevel) {
        this.keepLevel = keepLevel;
    }

    public void setKeepInventory(boolean keepInventory) {
        this.keepInventory = keepInventory;
    }

    public boolean getKeepInventory() {
        return this.keepInventory;
    }
}

