/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.entity;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.entity.PotionSplashEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class WaterBottleSplashEvent
extends PotionSplashEvent {
    private final Set<LivingEntity> rehydrate;
    private final Set<LivingEntity> extinguish;

    @ApiStatus.Internal
    public WaterBottleSplashEvent(ThrownPotion potion, @Nullable Entity hitEntity, @Nullable Block hitBlock, @Nullable BlockFace hitFace, Map<LivingEntity, Double> affectedEntities, Set<LivingEntity> rehydrate, Set<LivingEntity> extinguish) {
        super(potion, hitEntity, hitBlock, hitFace, affectedEntities);
        this.rehydrate = rehydrate;
        this.extinguish = extinguish;
    }

    public @Unmodifiable Collection<LivingEntity> getToDamage() {
        return this.affectedEntities.entrySet().stream().filter(entry -> (Double)entry.getValue() > 0.0).map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
    }

    public void doNotDamageAsWaterSensitive(LivingEntity entity) {
        this.affectedEntities.remove(entity);
    }

    public void damageAsWaterSensitive(LivingEntity entity) {
        this.affectedEntities.put(entity, 1.0);
    }

    public Collection<LivingEntity> getToRehydrate() {
        return this.rehydrate;
    }

    public Collection<LivingEntity> getToExtinguish() {
        return this.extinguish;
    }

    @Override
    @Deprecated(since="1.19.3")
    public Collection<LivingEntity> getAffectedEntities() {
        return super.getAffectedEntities();
    }

    @Override
    @Deprecated(since="1.19.3")
    public double getIntensity(LivingEntity entity) {
        return super.getIntensity(entity);
    }

    @Override
    @Deprecated(since="1.19.3")
    public void setIntensity(LivingEntity entity, double intensity) {
        super.setIntensity(entity, intensity);
    }
}

