/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.item.ItemComponentTypesBridge;
import io.papermc.paper.registry.set.RegistryKeySet;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.util.TriState;
import org.bukkit.block.BlockType;
import org.checkerframework.checker.index.qual.NonNegative;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface Tool {
    @Contract(value="-> new", pure=true)
    public static Builder tool() {
        return ItemComponentTypesBridge.bridge().tool();
    }

    public static Rule rule(RegistryKeySet<BlockType> blocks, @Nullable Float speed, TriState correctForDrops) {
        return ItemComponentTypesBridge.bridge().rule(blocks, speed, correctForDrops);
    }

    @Contract(pure=true)
    public float defaultMiningSpeed();

    @Contract(pure=true)
    public @NonNegative int damagePerBlock();

    @Contract(pure=true)
    public @Unmodifiable List<Rule> rules();

    @ApiStatus.Experimental
    @ApiStatus.NonExtendable
    public static interface Builder
    extends DataComponentBuilder<Tool> {
        @Contract(value="_ -> this", mutates="this")
        public Builder damagePerBlock(@NonNegative int var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder defaultMiningSpeed(float var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addRule(Rule var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addRules(Collection<Rule> var1);
    }

    @ApiStatus.Experimental
    @ApiStatus.NonExtendable
    public static interface Rule {
        public RegistryKeySet<BlockType> blocks();

        public @Nullable Float speed();

        public TriState correctForDrops();
    }
}

