/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.world.border;

import io.papermc.paper.event.world.border.WorldBorderEvent;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class WorldBorderBoundsChangeEvent
extends WorldBorderEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private Type type;
    private final double oldSize;
    private double newSize;
    private long duration;
    private boolean cancelled;

    @ApiStatus.Internal
    public WorldBorderBoundsChangeEvent(@NotNull World world, @NotNull WorldBorder worldBorder, @NotNull Type type, double oldSize, double newSize, long duration) {
        super(world, worldBorder);
        this.type = type;
        this.oldSize = oldSize;
        this.newSize = newSize;
        this.duration = duration;
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    public double getOldSize() {
        return this.oldSize;
    }

    public double getNewSize() {
        return this.newSize;
    }

    public void setNewSize(double newSize) {
        this.newSize = Math.min(this.worldBorder.getMaxSize(), Math.max(1.0, newSize));
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = Math.min(9223372036854775L, Math.max(0L, duration));
        if (duration >= 0L && this.type == Type.INSTANT_MOVE) {
            this.type = Type.STARTED_MOVE;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum Type {
        STARTED_MOVE,
        INSTANT_MOVE;

    }
}

