/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.player;

import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PlayerAdvancementCriterionGrantEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    @NotNull
    private final Advancement advancement;
    @NotNull
    private final String criterion;
    @NotNull
    private final AdvancementProgress advancementProgress;
    private boolean cancelled;

    @ApiStatus.Internal
    public PlayerAdvancementCriterionGrantEvent(@NotNull Player player, @NotNull Advancement advancement, @NotNull String criterion) {
        super(player);
        this.advancement = advancement;
        this.criterion = criterion;
        this.advancementProgress = player.getAdvancementProgress(advancement);
    }

    @NotNull
    public Advancement getAdvancement() {
        return this.advancement;
    }

    @NotNull
    public String getCriterion() {
        return this.criterion;
    }

    @NotNull
    public AdvancementProgress getAdvancementProgress() {
        return this.advancementProgress;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

