package org.bukkit.entity;

import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

/**
 * Represents a Fireball.
 */
public interface Fireball extends Projectile, Explosive {

    /**
     * Fireballs fly straight and do not take setVelocity(...) well.
     *
     * @param direction the direction this fireball is flying toward
     */
    public void setDirection(@NotNull Vector direction);

    /**
     * Retrieve the direction this fireball is heading toward
     *
     * @return the direction
     */
    @NotNull
    public Vector getDirection();

    // Paper start - Expose power on fireball projectiles
    /**
     * {@inheritDoc}
     * <p>
     * Note: For fireball entities, their movement is also controlled by their power.
     *
     * @param velocity New velocity to travel with
     * @see #setPower(Vector)
     */
    @Override
    public void setVelocity(@NotNull Vector velocity);

    /**
     * Sets the power of a fireball. The power determines the direction and magnitude of its acceleration.
     *
     * @param power the power
     */
    public void setPower(@NotNull Vector power);

    /**
     * Gets the power of a fireball. The power determines the direction and magnitude of its acceleration.
     *
     * @return the power
     */
    @NotNull
    public Vector getPower();
    // Paper end - Expose power on fireball projectiles

}
