package io.papermc.paper.event.block;

import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

/**
 * Called when the progress of a block break is updated.
 */
public class BlockBreakProgressUpdateEvent extends BlockEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();

    private final float progress;
    private final Entity entity;

    @ApiStatus.Internal
    public BlockBreakProgressUpdateEvent(@NotNull final Block block, final float progress, @NotNull final Entity entity) {
        super(block);
        this.progress = progress;
        this.entity = entity;
    }

    /**
     * The progress of the block break
     * <p>
     * The progress ranges from 0.0 - 1.0, where 0 is no damage and
     * 1.0 is the most damaged
     *
     * @return The progress of the block break
     */
    public float getProgress() {
        return progress;
    }

    /**
     * The entity breaking the block.
     *
     * @return The entity breaking the block
     */
    @NotNull
    public Entity getEntity() {
        return entity;
    }

    @Override
    public @NotNull HandlerList getHandlers() {
        return HANDLER_LIST;
    }
    public static @NotNull HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}
