package com.destroystokyo.paper.event.player;

import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Called when the locale of the player is changed.
 *
 * @deprecated Replaced by {@link org.bukkit.event.player.PlayerLocaleChangeEvent} upstream
 */
@Deprecated(forRemoval = true) @ApiStatus.ScheduledForRemoval(inVersion = "1.21")
public class PlayerLocaleChangeEvent extends PlayerEvent {

    private static final HandlerList HANDLER_LIST = new HandlerList();

    private final String oldLocale;
    private final String newLocale;

    @ApiStatus.Internal
    public PlayerLocaleChangeEvent(final @NotNull Player player, final @Nullable String oldLocale, final @NotNull String newLocale) {
        super(player);
        this.oldLocale = oldLocale;
        this.newLocale = newLocale;
    }

    /**
     * Gets the locale the player switched from.
     *
     * @return player's old locale
     */
    @Nullable
    public String getOldLocale() {
        return this.oldLocale;
    }

    /**
     * Gets the locale the player is changed to.
     *
     * @return player's new locale
     */
    @NotNull
    public String getNewLocale() {
        return this.newLocale;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}
