package com.destroystokyo.paper.event.server;

import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import com.destroystokyo.paper.exception.ServerException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/**
 * Called whenever an exception is thrown in a recoverable section of the server.
 */
public class ServerExceptionEvent extends Event {

    private static final HandlerList HANDLER_LIST = new HandlerList();

    @NotNull private final ServerException exception;

    @ApiStatus.Internal
    public ServerExceptionEvent(@NotNull ServerException exception) {
        super(!Bukkit.isPrimaryThread());
        this.exception = exception;
    }

    /**
     * Gets the wrapped exception that was thrown.
     *
     * @return Exception thrown
     */
    @NotNull
    public ServerException getException() {
        return this.exception;
    }

    @NotNull
    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}
