package org.bukkit.block;

/**
 * Represents a captured state of a conduit.
 */
public interface Conduit extends TileState {

    // Paper start - Conduit API

    /**
     * Gets if the conduit is currently active.
     * <p>
     * Requires the conduit to be placed in the world.
     *
     * @return if the conduit is active
     */
    boolean isActive();

    /**
     * Gets the range in which the Conduit Power effect gets added to players.
     * <p>
     * Requires the conduit to be placed in the world.
     *
     * @return the range
     */
    int getRange();

    /**
     * Gets the current target of the conduit.
     *
     * @return the current target
     */
    @org.jetbrains.annotations.Nullable
    org.bukkit.entity.LivingEntity getTarget();
    // Paper end - Conduit API
}
