package com.destroystokyo.paper.event.player;

import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/**
 * Fired when a player boosts elytra flight with a firework
 */
public class PlayerElytraBoostEvent extends PlayerEvent implements Cancellable {

    private static final HandlerList HANDLER_LIST = new HandlerList();

    @NotNull private final ItemStack itemStack;
    @NotNull private final Firework firework;
    private boolean consume = true;

    private boolean cancelled;

    @ApiStatus.Internal
    public PlayerElytraBoostEvent(@NotNull Player player, @NotNull ItemStack itemStack, @NotNull Firework firework) {
        super(player);
        this.itemStack = itemStack;
        this.firework = firework;
    }

    /**
     * Get the firework itemstack used
     *
     * @return ItemStack of firework
     */
    @NotNull
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    /**
     * Get the firework entity that was spawned
     *
     * @return Firework entity
     */
    @NotNull
    public Firework getFirework() {
        return this.firework;
    }

    /**
     * Get whether to consume the firework or not
     *
     * @return {@code true} to consume
     */
    public boolean shouldConsume() {
        return this.consume;
    }

    /**
     * Set whether to consume the firework or not
     *
     * @param consume {@code true} to consume
     */
    public void setShouldConsume(boolean consume) {
        this.consume = consume;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @NotNull
    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}
